<?php
// admin/dashboard.php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}
$admin_name = htmlspecialchars($_SESSION['admin_name'] ?? 'Admin');
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Dashboard</title></head>
<body>
  <h2>Welcome, <?php echo $admin_name; ?></h2>
  <p><a href="logout.php">Logout</a></p>

  <h3>Users List</h3>
  <?php
  require_once __DIR__ . '/../inc/db.php';
  $res = $conn->query("SELECT id, name, email, created_at FROM users ORDER BY created_at DESC");
  if ($res->num_rows > 0) {
      echo "<table border='1' cellpadding='6'><tr><th>ID</th><th>Name</th><th>Email</th><th>Created</th></tr>";
      while ($row = $res->fetch_assoc()) {
          echo "<tr>";
          echo "<td>".intval($row['id'])."</td>";
          echo "<td>".htmlspecialchars($row['name'])."</td>";
          echo "<td>".htmlspecialchars($row['email'])."</td>";
          echo "<td>".htmlspecialchars($row['created_at'])."</td>";
          echo "</tr>";
      }
      echo "</table>";
  } else {
      echo "<p>No users yet.</p>";
  }
  ?>
</body>
</html>
