<?php
error_reporting(E_ERROR | E_PARSE); // temporarily hide warnings
session_start(); // Start session at the very top

// अगर user login नहीं है, redirect कर दो login page पर
if (!isset($_SESSION['user_id'])) {
    header("Location: auth-login-basic.php");
    exit();
}

require_once __DIR__ . '/../../inc/db.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json'); 

    try {
        $uploadDir = __DIR__ . '/uploads/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        $imageNames = [];
        if (!empty($_FILES['images']['name'][0])) {
            foreach ($_FILES['images']['tmp_name'] as $i => $tmp) {
                if ($_FILES['images']['error'][$i] === UPLOAD_ERR_OK) {
                    $ext  = pathinfo($_FILES['images']['name'][$i], PATHINFO_EXTENSION);
                    $file = uniqid('img_', true) . '.' . $ext;
                    move_uploaded_file($tmp, $uploadDir . $file);
                    $imageNames[] = $file;
                }
            }
        }

        // Prepare MySQLi statement
        $stmt = $conn->prepare(
            "INSERT INTO products (name, price, sell_price, distributor, quantity, details, images)
             VALUES (?, ?, ?, ?, ?, ?, ?)"
        );

        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }

        $images_json = json_encode($imageNames);

        // Bind parameters
        $stmt->bind_param(
            "sddssss", 
            $_POST['name'],
            $_POST['price'],
            $_POST['sell_price'],
            $_POST['distributor'],
            $_POST['quantity'],
            $_POST['details'],
            $images_json
        );

        if ($stmt->execute()) {
            echo json_encode(['status' => 1, 'message' => 'Product saved successfully']);
        } else {
            throw new Exception("Execute failed: " . $stmt->error);
        }

        $stmt->close();
        exit;
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['status' => 0, 'message' => $e->getMessage()]);
        exit;
    }
}
?> 

<?php
require_once __DIR__ . '/../../inc/db.php'; // $conn

$products = [];
$result = $conn->query("SELECT * FROM products ORDER BY id ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $row['images'] = json_decode($row['images'], true); // <-- JSON decode
        $products[] = $row;
    }
}
?>

<!DOCTYPE html>
<html
  lang="en"
  class="light-style layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="../assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title>Cards basic - UI elements | Sneat - Bootstrap 5 HTML Admin Template - Pro</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="../assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="../assets/vendor/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="../assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="../assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="../assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="../assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../assets/js/config.js"></script>
    
    
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
          <div class="app-brand demo">
            <a href="index.html" class="app-brand-link">
              <span class="app-brand-logo demo">
                <svg
                  width="25"
                  viewBox="0 0 25 42"
                  version="1.1"
                  xmlns="http://www.w3.org/2000/svg"
                  xmlns:xlink="http://www.w3.org/1999/xlink"
                >
                  <defs>
                    <path
                      d="M13.7918663,0.358365126 L3.39788168,7.44174259 C0.566865006,9.69408886 -0.379795268,12.4788597 0.557900856,15.7960551 C0.68998853,16.2305145 1.09562888,17.7872135 3.12357076,19.2293357 C3.8146334,19.7207684 5.32369333,20.3834223 7.65075054,21.2172976 L7.59773219,21.2525164 L2.63468769,24.5493413 C0.445452254,26.3002124 0.0884951797,28.5083815 1.56381646,31.1738486 C2.83770406,32.8170431 5.20850219,33.2640127 7.09180128,32.5391577 C8.347334,32.0559211 11.4559176,30.0011079 16.4175519,26.3747182 C18.0338572,24.4997857 18.6973423,22.4544883 18.4080071,20.2388261 C17.963753,17.5346866 16.1776345,15.5799961 13.0496516,14.3747546 L10.9194936,13.4715819 L18.6192054,7.984237 L13.7918663,0.358365126 Z"
                      id="path-1"
                    ></path>
                    <path
                      d="M5.47320593,6.00457225 C4.05321814,8.216144 4.36334763,10.0722806 6.40359441,11.5729822 C8.61520715,12.571656 10.0999176,13.2171421 10.8577257,13.5094407 L15.5088241,14.433041 L18.6192054,7.984237 C15.5364148,3.11535317 13.9273018,0.573395879 13.7918663,0.358365126 C13.5790555,0.511491653 10.8061687,2.3935607 5.47320593,6.00457225 Z"
                      id="path-3"
                    ></path>
                    <path
                      d="M7.50063644,21.2294429 L12.3234468,23.3159332 C14.1688022,24.7579751 14.397098,26.4880487 13.008334,28.506154 C11.6195701,30.5242593 10.3099883,31.790241 9.07958868,32.3040991 C5.78142938,33.4346997 4.13234973,34 4.13234973,34 C4.13234973,34 2.75489982,33.0538207 2.37032616e-14,31.1614621 C-0.55822714,27.8186216 -0.55822714,26.0572515 -4.05231404e-15,25.8773518 C0.83734071,25.6075023 2.77988457,22.8248993 3.3049379,22.52991 C3.65497346,22.3332504 5.05353963,21.8997614 7.50063644,21.2294429 Z"
                      id="path-4"
                    ></path>
                    <path
                      d="M20.6,7.13333333 L25.6,13.8 C26.2627417,14.6836556 26.0836556,15.9372583 25.2,16.6 C24.8538077,16.8596443 24.4327404,17 24,17 L14,17 C12.8954305,17 12,16.1045695 12,15 C12,14.5672596 12.1403557,14.1461923 12.4,13.8 L17.4,7.13333333 C18.0627417,6.24967773 19.3163444,6.07059163 20.2,6.73333333 C20.3516113,6.84704183 20.4862915,6.981722 20.6,7.13333333 Z"
                      id="path-5"
                    ></path>
                  </defs>
                  <g id="g-app-brand" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g id="Brand-Logo" transform="translate(-27.000000, -15.000000)">
                      <g id="Icon" transform="translate(27.000000, 15.000000)">
                        <g id="Mask" transform="translate(0.000000, 8.000000)">
                          <mask id="mask-2" fill="white">
                            <use xlink:href="#path-1"></use>
                          </mask>
                          <use fill="#696cff" xlink:href="#path-1"></use>
                          <g id="Path-3" mask="url(#mask-2)">
                            <use fill="#696cff" xlink:href="#path-3"></use>
                            <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-3"></use>
                          </g>
                          <g id="Path-4" mask="url(#mask-2)">
                            <use fill="#696cff" xlink:href="#path-4"></use>
                            <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-4"></use>
                          </g>
                        </g>
                        <g
                          id="Triangle"
                          transform="translate(19.000000, 11.000000) rotate(-300.000000) translate(-19.000000, -11.000000) "
                        >
                          <use fill="#696cff" xlink:href="#path-5"></use>
                          <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-5"></use>
                        </g>
                      </g>
                    </g>
                  </g>
                </svg>
              </span>
              <span class="app-brand-text demo menu-text fw-bolder ms-2">Sneat</span>
            </a>

            <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
              <i class="bx bx-chevron-left bx-sm align-middle"></i>
            </a>
          </div>

          <div class="menu-inner-shadow"></div>

          <ul class="menu-inner py-1">
            <!-- Dashboard -->
            <li class="menu-item">
              <a href="index.php" class="menu-link">
                <i class="menu-icon tf-icons bx bx-home-circle"></i>
                <div data-i18n="Analytics">Dashboard</div>
              </a>
            </li>
 
             <li class="menu-item active">
              <a href="product-card.php" class="menu-link">
                <i class="menu-icon tf-icons bx bx-collection"></i>
                <div data-i18n="Basic">Products</div>
              </a>
            </li>  
            
            <!-- Tables -->
            <li class="menu-item">
              <a href="tables-basic.php" class="menu-link">
                <i class="menu-icon tf-icons bx bx-table"></i>
                <div data-i18n="Tables">Products Tables</div>
              </a>
            </li> 
          </ul>
        </aside>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <nav
            class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
            id="layout-navbar"
          >
            <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
              <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
              </a>
            </div>

            <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
              <!-- Search -->
              <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                  <i class="bx bx-search fs-4 lh-0"></i>
                  <input
                    type="text"
                    class="form-control border-0 shadow-none"
                    placeholder="Search..."
                    aria-label="Search..."
                  />
                </div>
              </div>
              <!-- /Search -->

              <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- Place this tag where you want the button to render. -->
                <li class="nav-item lh-1 me-3">
                  <a
                    class="github-button"
                    href="https://github.com/themeselection/sneat-html-admin-template-free"
                    data-icon="octicon-star"
                    data-size="large"
                    data-show-count="true"
                    aria-label="Star themeselection/sneat-html-admin-template-free on GitHub"
                    >Star</a
                  >
                </li>

                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                  <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                    <div class="avatar avatar-online">
                      <img src="../assets/img/avatars/1.png" alt class="w-px-40 h-auto rounded-circle" />
                    </div>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                      <a class="dropdown-item" href="#">
                        <div class="d-flex">
                          <div class="flex-shrink-0 me-3">
                            <div class="avatar avatar-online">
                              <img src="../assets/img/avatars/1.png" alt class="w-px-40 h-auto rounded-circle" />
                            </div>
                          </div>
                          <div class="flex-grow-1">
                            <span class="fw-semibold d-block">John Doe</span>
                            <small class="text-muted">Admin</small>
                          </div>
                        </div>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-user me-2"></i>
                        <span class="align-middle">My Profile</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-cog me-2"></i>
                        <span class="align-middle">Settings</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <span class="d-flex align-items-center align-middle">
                          <i class="flex-shrink-0 bx bx-credit-card me-2"></i>
                          <span class="flex-grow-1 align-middle">Billing</span>
                          <span class="flex-shrink-0 badge badge-center rounded-pill bg-danger w-px-20 h-px-20">4</span>
                        </span>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="auth-login-basic.html">
                        <i class="bx bx-power-off me-2"></i>
                        <span class="align-middle">Log Out</span>
                      </a>
                    </li>
                  </ul>
                </li>
                <!--/ User -->
              </ul>
            </div>
          </nav>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
                

              <!-- Grid Card -->
              <div class="d-flex justify-content-between align-items-center mb-4">
                 <h5 class="pb-1 mb-0 text-muted">Grid Card</h5>
                 <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                          data-bs-target="#modalCenter">Add Product</button>
              </div>
              <!-- Vertically Centered Modal -->
                    <div class="col-lg-4 col-md-6"> 
                      <div class="mt-3"> 

                        <!-- Modal -->
                        <div class="modal fade" id="modalCenter" tabindex="-1" aria-hidden="true">
                          <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                 <form id="productForm" enctype="multipart/form-data">
                              <div class="modal-header">
                                <h5 class="modal-title" id="modalCenterTitle">Modal title</h5>
                                <button
                                  type="button"
                                  class="btn-close"
                                  data-bs-dismiss="modal"
                                  aria-label="Close"
                                ></button>
                              </div>
                              <div class="modal-body">
                                <div class="row">
                                  <div class="col mb-3">
                                    <label for="nameWithTitle" class="form-label">Name</label>
                                    <input
                                      type="text"
                                      id="nameWithTitle"
                                      name="name"
                                      class="form-control"
                                      placeholder="Enter Name"
                                      required
                                    />
                                  </div>
                                </div>
                                <div class="row g-2 mb-3">
                                  <div class="col mb-0">
                                    <label for="priceWithTitle" class="form-label">Price</label>
                                    <input
                                      type="number"
                                      id="priceWithTitle"
                                      name="price"
                                      class="form-control"
                                      placeholder="Enter Price"
                                      required
                                    />
                                  </div>
                                  <div class="col mb-0">
                                    <label for="sellpriceWithTitle" class="form-label">Sell Price</label>
                                    <input
                                      type="number"
                                      id="sellpriceWithTitle"
                                      name="sell_price"
                                      class="form-control"
                                      placeholder="Enter Sell Price"
                                      required
                                    />
                                  </div> 
                                </div>
                                <div class="row g-2 mb-3">
                                  <div class="col mb-0">
                                    <label for="distributernameWithTitle" class="form-label">Distributer Name</label>
                                    <input
                                      type="text"
                                      id="distributernameWithTitle"
                                      class="form-control"
                                      name="distributor"
                                      placeholder="Enter Distributer Name"
                                      required
                                    />
                                  </div>
                                  <div class="col mb-0">
                                    <label for="quantityWithTitle" class="form-label">Product Quantity</label>
                                    <input
                                      type="number"
                                      id="quantityWithTitle"
                                      name="quantity"
                                      class="form-control"
                                      placeholder="Enter Product Quantity"
                                      required
                                    />
                                  </div> 
                                </div>
                                <div class="row">
                                  <div class="col mb-3">
                                    <label for="details" class="form-label">Details</label>
                                    <textarea
                                      type="text"
                                      id="details"
                                      class="form-control"
                                      name="details"
                                      placeholder="Hi, please Fill Details?"
                                      aria-label="Hi, please Fill Details?"
                                      aria-describedby="basic-icon-default-message2"
                                    ></textarea>
                                  </div>
                                </div> 
                                 <div class="mb-3">
                                    <label for="formFileMultiple" class="form-label">Multiple files input example</label>
                                    <input class="form-control" type="file" id="formFileMultiple" name="images[]" multiple accept=".png,.jpg,.jpeg"/>
                                  </div>
                                  <div id="previewBox" class="d-none border p-2 rounded" 
                                       style="display:flex; gap:10px; overflow-x:auto;">
                                  </div>
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                  Close
                                </button>
                                <button type="submit" class="btn btn-primary">Save changes</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
              <div class="row row-cols-1 row-cols-md-5 g-4 mb-5">
                <?php foreach ($products as $product): ?>
                    <div class="col">
                        <div class="card h-100" data-bs-toggle="modal" data-bs-target="#productModal-<?php echo $product['id']; ?>" style="cursor:pointer;">
                            <?php if (!empty($product['images'])): ?>
                              <img class="card-img-top" src="https://shivfood.clicksoft.in/admin/html/uploads/<?php echo htmlspecialchars($product['images'][0]); ?>" alt="Product Image" />
                            <?php else: ?>
                                <img class="card-img-top" src="../assets/img/elements/placeholder.jpg" alt="No Image" />
                            <?php endif; ?>
                            <div class="card-body"> 
                                <p class="card-text">
                                    <strong>Name:</strong> <?php echo htmlspecialchars($product['name']); ?><br>
                                    <strong>Sell Price:</strong> ₹<?php echo number_format($product['sell_price'], 2); ?><br>
                                    <strong>Price:</strong> ₹<?php echo number_format($product['price'], 2); ?><br> 
                                    <strong>Quantity:</strong> <?php echo intval($product['quantity']); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- Modal -->
                        <div class="modal fade" id="productModal-<?php echo $product['id']; ?>" tabindex="-1" aria-hidden="true">
                          <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                 
                              <div class="modal-header">
                                <h5 class="modal-title" id="modalCenterTitle">Product Details</h5>
                                <button
                                  type="button"
                                  class="btn-close"
                                  data-bs-dismiss="modal"
                                  aria-label="Close"
                                ></button>
                              </div>
                              <div class="modal-body">
                                <div class="row">
                                  <div class="col mb-3">
                                    <label for="nameWithTitle" class="form-label">Name</label>
                                    <input
                                      type="text"
                                      id="nameWithTitle"
                                      name="name"
                                      class="form-control"
                                      placeholder="N/A"
                                      value="<?php echo htmlspecialchars($product['name']); ?>"
                                      disabled
                                    />
                                  </div>
                                </div>
                                <div class="row g-2 mb-3">
                                  <div class="col mb-0">
                                    <label for="priceWithTitle" class="form-label">Price</label>
                                    <input
                                      type="number"
                                      id="priceWithTitle"
                                      name="price"
                                      class="form-control"
                                      placeholder="N/A"
                                      value="<?php echo number_format($product['price'], 2); ?>"
                                      disabled
                                    />
                                  </div>
                                  <div class="col mb-0">
                                    <label for="sellpriceWithTitle" class="form-label">Sell Price</label>
                                    <input
                                      type="number"
                                      id="sellpriceWithTitle"
                                      name="sell_price"
                                      class="form-control"
                                      placeholder="N/A"
                                      value="<?php echo number_format($product['sell_price'], 2); ?>"
                                      disabled
                                    />
                                  </div> 
                                </div>
                                <div class="row g-2 mb-3">
                                  <div class="col mb-0">
                                    <label for="distributernameWithTitle" class="form-label">Distributer Name</label>
                                    <input
                                      type="text"
                                      id="distributernameWithTitle"
                                      class="form-control"
                                      name="distributor"
                                      placeholder="N/A"
                                      value="<?php echo htmlspecialchars($product['distributor']); ?>"
                                      disabled
                                    />
                                  </div>
                                  <div class="col mb-0">
                                    <label for="quantityWithTitle" class="form-label">Product Quantity</label>
                                    <input
                                      type="number"
                                      id="quantityWithTitle"
                                      name="quantity"
                                      class="form-control"
                                      placeholder="N/A"
                                      value="<?php echo intval($product['quantity']); ?>"
                                      disabled
                                    />
                                  </div> 
                                </div>
                                <div class="row">
                                  <div class="col mb-3">
                                    <label for="basic-default-message" class="form-label">Details</label>
                                    <textarea
                                      id="basic-default-message"
                                      class="form-control"
                                      name="details"
                                      placeholder="N/A"
                                      aria-label="N/A"
                                      disabled
                                      aria-describedby="basic-icon-default-message2"
                                    ><?php echo htmlspecialchars($product['details']); ?></textarea>
                                  </div>
                                </div> 
                                 
                                  <?php if (!empty($product['images'])): ?>
                                    <div class="d-flex gap-2 border p-2 rounded overflow-auto mb-3">
                                        <?php foreach ($product['images'] as $img): ?>
                                            <a href="uploads/<?php echo htmlspecialchars($img); ?>" target="_blank">
                                                <img src="uploads/<?php echo htmlspecialchars($img); ?>"
                                                     style="height:80px; border-radius:4px; cursor:pointer;">
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                              </div> 
                            </div>
                          </div>
                        </div>
                <?php endforeach; ?>
                </div> 
            </div>
            <!-- / Content -->

            <!-- Footer -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                <div class="mb-2 mb-md-0">
                  ©
                  <script>
                    document.write(new Date().getFullYear());
                  </script>
                  , made with ❤️ by
                  <a href="https://themeselection.com" target="_blank" class="footer-link fw-bolder">ThemeSelection</a>
                </div>
                <div>
                  <a href="https://themeselection.com/license/" class="footer-link me-4" target="_blank">License</a>
                  <a href="https://themeselection.com/" target="_blank" class="footer-link me-4">More Themes</a>

                  <a
                    href="https://themeselection.com/demo/sneat-bootstrap-html-admin-template/documentation/"
                    target="_blank"
                    class="footer-link me-4"
                    >Documentation</a
                  >

                  <a
                    href="https://github.com/themeselection/sneat-html-admin-template-free/issues"
                    target="_blank"
                    class="footer-link me-4"
                    >Support</a
                  >
                </div>
              </div>
            </footer>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->
 

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../assets/vendor/libs/popper/popper.js"></script>
    <script src="../assets/vendor/js/bootstrap.js"></script>
    <script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="../assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="../assets/vendor/libs/masonry/masonry.js"></script>

    <!-- Main JS -->
    <script src="../assets/js/main.js"></script>

    
    <!-- Toast JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- Page JS -->

    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
   <script>
    // $(function(){
       
    //   $('#formFileMultiple').on('change', function(){
    //     const box = $('#previewBox').empty();
    //     if(this.files.length){
    //       box.removeClass('d-none').show();
    //       [...this.files].forEach(f=>{
    //         const reader = new FileReader();
    //         reader.onload = e=>{
    //           box.append(`<img src="${e.target.result}" style="height:80px;border-radius:4px;">`);
    //         };
    //         reader.readAsDataURL(f);
    //       });
    //     } else { box.addClass('d-none').hide(); }
    //   });
$(function() {
    let newImages = [];

    // Image Preview
    function updatePreview() {
        const box = $('#previewBox').empty();
        if(newImages.length) {
            box.removeClass('d-none').show();
            newImages.forEach((file, i) => {
                const reader = new FileReader();
                reader.onload = e => {
                    const wrapper = $(`
                        <div style="position:relative;width:120px;height:120px;">
                            <img src="${e.target.result}" style="width:100%;height:100%;object-fit:cover;border-radius:4px;">
                            <span class="remove-img" style="
                                position:absolute;
                                top:5px; right:5px;
                                width:24px; height:24px;
                                display:flex; align-items:center; justify-content:center;
                                background:red; color:white; font-weight:bold;
                                border-radius:50%; cursor:pointer; font-size:16px;
                                box-shadow:0 0 4px rgba(0,0,0,0.5);
                            ">×</span>
                        </div>
                    `);
                    wrapper.find('.remove-img').on('click', function(){
                        newImages.splice(i,1);
                        updatePreview();
                    });
                    box.append(wrapper);
                };
                reader.readAsDataURL(file);
            });
        } else {
            box.addClass('d-none').hide();
        }
    }

    // Select Images
    $('#formFileMultiple').on('change', function(){
        [...this.files].forEach(f => newImages.push(f));
        updatePreview();
    });
  // Submit form 
   $('#productForm').on('submit', function(e){
    e.preventDefault();
    const fd = new FormData(this);
    $.ajax({
        url: '', // same page
        type: 'POST',
        data: fd,
        processData: false,
        contentType: false,
        success: function(res){
            toastr.success(res.message);
            // Close modal
            bootstrap.Modal.getInstance(document.getElementById('modalCenter')).hide();
            // Reset form & preview
            $('#productForm')[0].reset();
            $('#previewBox').empty().hide();
        },
        error: function(xhr){
             console.log("XHR response:", xhr.responseText);  
            let msg = 'Error saving product';
            try { msg = JSON.parse(xhr.responseText).message; } catch(e){}
            toastr.error(msg);
        }
    });
});
});
</script>
  </body>
</html>
