<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
// अगर user login नहीं है, redirect कर दो login page पर
if (!isset($_SESSION['user_id'])) {
    header("Location: auth-login-basic.php");
    exit();
}

require_once __DIR__ . '/../../inc/db.php'; // $conn

// ==== Delete product (Ajax) ====
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'delete_product') {
    header('Content-Type: application/json');
    $id = intval($_POST['id'] ?? 0);
    if ($id > 0) {
        $stmt = $conn->prepare("DELETE FROM products WHERE id=?");
        $stmt->bind_param('i', $id);
        if ($stmt->execute()) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => $stmt->error]);
        }
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid ID']);
    }
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'products') {
    $id = intval($_POST['id']);
    $name = $_POST['name'] ?? '';
    $price = floatval($_POST['price'] ?? 0);
    $sell_price = floatval($_POST['sell_price'] ?? 0);
    $distributor = $_POST['distributor'] ?? '';
    $quantity = intval($_POST['quantity'] ?? 0);
    $details = $_POST['details'] ?? '';
    $existing = json_decode($_POST['existing_images'] ?? '[]', true);

    // Handle new images upload
    $newImages = [];
    if (!empty($_FILES['images']['name'][0])) {
        $uploadDir = __DIR__ . '/uploads/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        foreach ($_FILES['images']['name'] as $k => $nameFile) {
            $tmp = $_FILES['images']['tmp_name'][$k];
            $ext = pathinfo($nameFile, PATHINFO_EXTENSION);
            $filename = uniqid() . '_' . time() . '.' . $ext;
            if (move_uploaded_file($tmp, $uploadDir . $filename)) {
                $newImages[] = $filename;
            }
        }
    }

    $allImages = array_merge($existing, $newImages);
    $imagesJson = json_encode($allImages, JSON_UNESCAPED_UNICODE);

    // Correct bind_param types: s = string, d = double, i = int
    $stmt = $conn->prepare("UPDATE products SET name=?, price=?, sell_price=?, distributor=?, quantity=?, details=?, images=? WHERE id=?");
    $stmt->bind_param('sddsissi', $name, $price, $sell_price, $distributor, $quantity, $details, $imagesJson, $id);

    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => $stmt->error]);
    }
    exit;
}

$products = [];
$result = $conn->query("SELECT * FROM products ORDER BY id ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $row['images'] = json_decode($row['images'], true); // <-- JSON decode
        $products[] = $row;
    }
}

?>

<!DOCTYPE html>

<html
  lang="en"
  class="light-style layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="../assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title>Tables - Basic Tables | Sneat - Bootstrap 5 HTML Admin Template - Pro</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="../assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="../assets/vendor/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="../assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="../assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="../assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="../assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../assets/js/config.js"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
          <div class="app-brand demo">
            <a href="index.html" class="app-brand-link">
              <span class="app-brand-logo demo">
                <svg
                  width="25"
                  viewBox="0 0 25 42"
                  version="1.1"
                  xmlns="http://www.w3.org/2000/svg"
                  xmlns:xlink="http://www.w3.org/1999/xlink"
                >
                  <defs>
                    <path
                      d="M13.7918663,0.358365126 L3.39788168,7.44174259 C0.566865006,9.69408886 -0.379795268,12.4788597 0.557900856,15.7960551 C0.68998853,16.2305145 1.09562888,17.7872135 3.12357076,19.2293357 C3.8146334,19.7207684 5.32369333,20.3834223 7.65075054,21.2172976 L7.59773219,21.2525164 L2.63468769,24.5493413 C0.445452254,26.3002124 0.0884951797,28.5083815 1.56381646,31.1738486 C2.83770406,32.8170431 5.20850219,33.2640127 7.09180128,32.5391577 C8.347334,32.0559211 11.4559176,30.0011079 16.4175519,26.3747182 C18.0338572,24.4997857 18.6973423,22.4544883 18.4080071,20.2388261 C17.963753,17.5346866 16.1776345,15.5799961 13.0496516,14.3747546 L10.9194936,13.4715819 L18.6192054,7.984237 L13.7918663,0.358365126 Z"
                      id="path-1"
                    ></path>
                    <path
                      d="M5.47320593,6.00457225 C4.05321814,8.216144 4.36334763,10.0722806 6.40359441,11.5729822 C8.61520715,12.571656 10.0999176,13.2171421 10.8577257,13.5094407 L15.5088241,14.433041 L18.6192054,7.984237 C15.5364148,3.11535317 13.9273018,0.573395879 13.7918663,0.358365126 C13.5790555,0.511491653 10.8061687,2.3935607 5.47320593,6.00457225 Z"
                      id="path-3"
                    ></path>
                    <path
                      d="M7.50063644,21.2294429 L12.3234468,23.3159332 C14.1688022,24.7579751 14.397098,26.4880487 13.008334,28.506154 C11.6195701,30.5242593 10.3099883,31.790241 9.07958868,32.3040991 C5.78142938,33.4346997 4.13234973,34 4.13234973,34 C4.13234973,34 2.75489982,33.0538207 2.37032616e-14,31.1614621 C-0.55822714,27.8186216 -0.55822714,26.0572515 -4.05231404e-15,25.8773518 C0.83734071,25.6075023 2.77988457,22.8248993 3.3049379,22.52991 C3.65497346,22.3332504 5.05353963,21.8997614 7.50063644,21.2294429 Z"
                      id="path-4"
                    ></path>
                    <path
                      d="M20.6,7.13333333 L25.6,13.8 C26.2627417,14.6836556 26.0836556,15.9372583 25.2,16.6 C24.8538077,16.8596443 24.4327404,17 24,17 L14,17 C12.8954305,17 12,16.1045695 12,15 C12,14.5672596 12.1403557,14.1461923 12.4,13.8 L17.4,7.13333333 C18.0627417,6.24967773 19.3163444,6.07059163 20.2,6.73333333 C20.3516113,6.84704183 20.4862915,6.981722 20.6,7.13333333 Z"
                      id="path-5"
                    ></path>
                  </defs>
                  <g id="g-app-brand" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g id="Brand-Logo" transform="translate(-27.000000, -15.000000)">
                      <g id="Icon" transform="translate(27.000000, 15.000000)">
                        <g id="Mask" transform="translate(0.000000, 8.000000)">
                          <mask id="mask-2" fill="white">
                            <use xlink:href="#path-1"></use>
                          </mask>
                          <use fill="#696cff" xlink:href="#path-1"></use>
                          <g id="Path-3" mask="url(#mask-2)">
                            <use fill="#696cff" xlink:href="#path-3"></use>
                            <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-3"></use>
                          </g>
                          <g id="Path-4" mask="url(#mask-2)">
                            <use fill="#696cff" xlink:href="#path-4"></use>
                            <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-4"></use>
                          </g>
                        </g>
                        <g
                          id="Triangle"
                          transform="translate(19.000000, 11.000000) rotate(-300.000000) translate(-19.000000, -11.000000) "
                        >
                          <use fill="#696cff" xlink:href="#path-5"></use>
                          <use fill-opacity="0.2" fill="#FFFFFF" xlink:href="#path-5"></use>
                        </g>
                      </g>
                    </g>
                  </g>
                </svg>
              </span>
              <span class="app-brand-text demo menu-text fw-bolder ms-2">Sneat</span>
            </a>

            <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
              <i class="bx bx-chevron-left bx-sm align-middle"></i>
            </a>
          </div>

          <div class="menu-inner-shadow"></div>

          <ul class="menu-inner py-1">
            <!-- Dashboard -->
            <li class="menu-item">
              <a href="index.php" class="menu-link">
                <i class="menu-icon tf-icons bx bx-home-circle"></i>
                <div data-i18n="Analytics">Dashboard</div>
              </a>
            </li>
 
             <li class="menu-item">
              <a href="product-card.php" class="menu-link">
                <i class="menu-icon tf-icons bx bx-collection"></i>
                <div data-i18n="Basic">Products</div>
              </a>
            </li>  
            
            <!-- Tables -->
            <li class="menu-item active">
              <a href="tables-basic.php" class="menu-link">
                <i class="menu-icon tf-icons bx bx-table"></i>
                <div data-i18n="Tables">Products Tables</div>
              </a>
            </li> 
          </ul>
        </aside>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <nav
            class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
            id="layout-navbar"
          >
            <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
              <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
              </a>
            </div>

            <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
              <!-- Search -->
              <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                  <i class="bx bx-search fs-4 lh-0"></i>
                  <input
                    type="text"
                    class="form-control border-0 shadow-none"
                    placeholder="Search..."
                    aria-label="Search..."
                  />
                </div>
              </div>
              <!-- /Search -->

              <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- Place this tag where you want the button to render. -->
                <li class="nav-item lh-1 me-3">
                  <a
                    class="github-button"
                    href="https://github.com/themeselection/sneat-html-admin-template-free"
                    data-icon="octicon-star"
                    data-size="large"
                    data-show-count="true"
                    aria-label="Star themeselection/sneat-html-admin-template-free on GitHub"
                    >Star</a
                  >
                </li>

                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                  <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                    <div class="avatar avatar-online">
                      <img src="../assets/img/avatars/1.png" alt class="w-px-40 h-auto rounded-circle" />
                    </div>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                      <a class="dropdown-item" href="#">
                        <div class="d-flex">
                          <div class="flex-shrink-0 me-3">
                            <div class="avatar avatar-online">
                              <img src="../assets/img/avatars/1.png" alt class="w-px-40 h-auto rounded-circle" />
                            </div>
                          </div>
                          <div class="flex-grow-1">
                            <span class="fw-semibold d-block">John Doe</span>
                            <small class="text-muted">Admin</small>
                          </div>
                        </div>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-user me-2"></i>
                        <span class="align-middle">My Profile</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-cog me-2"></i>
                        <span class="align-middle">Settings</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <span class="d-flex align-items-center align-middle">
                          <i class="flex-shrink-0 bx bx-credit-card me-2"></i>
                          <span class="flex-grow-1 align-middle">Billing</span>
                          <span class="flex-shrink-0 badge badge-center rounded-pill bg-danger w-px-20 h-px-20">4</span>
                        </span>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="auth-login-basic.html">
                        <i class="bx bx-power-off me-2"></i>
                        <span class="align-middle">Log Out</span>
                      </a>
                    </li>
                  </ul>
                </li>
                <!--/ User -->
              </ul>
            </div>
          </nav>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y"> 
              <!-- Responsive Table -->
              <div class="card">
                <h5 class="card-header">Responsive Table</h5>
                <div class="table-responsive text-nowrap">
                  <table class="table">
                    <thead>
                      <tr class="text-nowrap">
                        <th>#</th>
                        <th>Name</th>
                        <th>Price</th>
                        <th>Sell Price</th>
                        <th>Distributer Name</th>
                        <th>Product Quantity</th>
                        <th>Details</th>
                        <th>Image</th> 
                        <th>Print Bill</th>
                        <th>Action</th> 
                      </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($products as $p): ?>
                      <tr> 
                        <th scope="row"><?= $p['id']; ?></td>
                        <td><?= htmlspecialchars($p['name']); ?></td>
                        <td>₹<?= number_format($p['price'],2); ?></td>
                        <td>₹<?= number_format($p['sell_price'],2); ?></td>
                        <td><?= htmlspecialchars($p['distributor']); ?></td>
                        <td><?= intval($p['quantity']); ?></td>
                        <td><?= nl2br(htmlspecialchars($p['details'])); ?></td>
                        <td> 
                        <?php if (!empty($p['images'])): ?>
                            <?php $limitedImgs = array_slice($p['images'], 0, 3); ?>
                            <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                <?php foreach ($limitedImgs as $img): ?>
                                    <li class="avatar avatar-xs pull-up" title="<?= htmlspecialchars($p['name']) ?>">
                                        <a href="uploads/<?= htmlspecialchars($img) ?>" target="_blank">
                                            <img src="uploads/<?= htmlspecialchars($img) ?>" class="rounded-circle" alt="img">
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                          </td>
                          <td>
                            <button type="button" class="btn btn-primary">Print Bill</button>
                        </td>
                        <td>
                             <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                   data-bs-target="#editProduct"
                                   data-id="<?= $p['id'] ?>"
                                   data-name="<?= htmlspecialchars($p['name']) ?>"
                                   data-price="<?= htmlspecialchars($p['price']) ?>"
                                   data-sell="<?= htmlspecialchars($p['sell_price']) ?>"
                                   data-distributor="<?= htmlspecialchars($p['distributor']) ?>"
                                   data-quantity="<?= htmlspecialchars($p['quantity']) ?>"
                                   data-details="<?= htmlspecialchars($p['details']) ?>"
                                   data-images='<?= json_encode($p["images"] ?? []) ?>'>Edit</button>
                              <button type="button" class="btn btn-danger"  data-bs-toggle="modal"
                                data-bs-target="#deleteModal"
                                data-id="<?= $p['id'] ?>"
                                data-name="<?= htmlspecialchars($p['name']) ?>">Delete</button> 
                        </td> 
                      </tr> 
                     
                       <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
              <!--/ Responsive Table -->
            </div>
            <!-- / Content -->
                        <div class="modal fade" id="editProduct" tabindex="-1" aria-hidden="true">
                          <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                 <form id="productForm" enctype="multipart/form-data">
                                     <input type="hidden" name="id" />
                              <div class="modal-header">
                                <h5 class="modal-title" id="modalCenterTitle">Product Edit</h5>
                                <button
                                  type="button"
                                  class="btn-close"
                                  data-bs-dismiss="modal"
                                  aria-label="Close"
                                ></button>
                              </div>
                              <div class="modal-body">
                                <div class="row">
                                  <div class="col mb-3">
                                    <label for="nameWithTitle" class="form-label">Name</label>
                                    <input
                                      type="text"
                                      id="nameWithTitle"
                                      name="name"
                                      class="form-control"
                                      placeholder="Enter Name"
                                      required
                                    />
                                  </div>
                                </div>
                                <div class="row g-2 mb-3">
                                  <div class="col mb-0">
                                    <label for="priceWithTitle" class="form-label">Price</label>
                                    <input
                                      type="number"
                                      id="priceWithTitle"
                                      name="price"
                                      class="form-control"
                                      placeholder="Enter Price"
                                      required
                                    />
                                  </div>
                                  <div class="col mb-0">
                                    <label for="sellpriceWithTitle" class="form-label">Sell Price</label>
                                    <input
                                      type="number"
                                      id="sellpriceWithTitle"
                                      name="sell_price"
                                      class="form-control"
                                      placeholder="Enter Sell Price"
                                      required
                                    />
                                  </div> 
                                </div>
                                <div class="row g-2 mb-3">
                                  <div class="col mb-0">
                                    <label for="distributernameWithTitle" class="form-label">Distributer Name</label>
                                    <input
                                      type="text"
                                      id="distributernameWithTitle"
                                      class="form-control"
                                      name="distributor"
                                      placeholder="Enter Distributer Name"
                                      required
                                    />
                                  </div>
                                  <div class="col mb-0">
                                    <label for="quantityWithTitle" class="form-label">Product Quantity</label>
                                    <input
                                      type="number"
                                      id="quantityWithTitle"
                                      name="quantity"
                                      class="form-control"
                                      placeholder="Enter Product Quantity"
                                      required
                                    />
                                  </div> 
                                </div>
                                <div class="row">
                                  <div class="col mb-3">
                                    <label for="details" class="form-label">Details</label>
                                    <textarea
                                      type="text"
                                      id="details"
                                      class="form-control"
                                      name="details"
                                      placeholder="Hi, please Fill Details?"
                                      aria-label="Hi, please Fill Details?"
                                      aria-describedby="basic-icon-default-message2"
                                    ></textarea>
                                  </div>
                                </div> 
                                 <div class="mb-3">
                                    <label for="formFileMultiple" class="form-label">Multiple files input example</label>
                                    <input class="form-control" type="file" id="formFileMultiple" name="images[]" multiple accept=".png,.jpg,.jpeg"/>
                                  </div>
                                  <div id="previewBox" class="d-none border p-2 rounded" 
                                       style="display:flex; gap:10px; overflow-x:auto;">
                                  </div>
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                  Close
                                </button>
                                <button type="submit" class="btn btn-primary">Save changes</button>
                                  <span class="spinner-border spinner-border-sm d-none" role="status" id="loadingSpinner"></span>

                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        
                        <!-- Small Modal -->
                      <div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="exampleModalLabel2">Delete <strong id="deleteName"></strong></h5>
                              <button
                                type="button"
                                class="btn-close"
                                data-bs-dismiss="modal"
                                aria-label="Close"
                              ></button>
                            </div>
                            <div class="modal-body">
                              Are You Sure Want to Delete?
                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                No
                              </button>
                              <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Yes</button>
                              <span class="spinner-border spinner-border-sm d-none" id="deleteSpinner" role="status"></span>
                            </div>
                          </div>
                        </div>
                      </div>
            <!-- Footer -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                <div class="mb-2 mb-md-0">
                  ©
                  <script>
                    document.write(new Date().getFullYear());
                  </script>
                  , made with ❤️ by
                  <a href="https://themeselection.com" target="_blank" class="footer-link fw-bolder">ThemeSelection</a>
                </div>
                <div>
                  <a href="https://themeselection.com/license/" class="footer-link me-4" target="_blank">License</a>
                  <a href="https://themeselection.com/" target="_blank" class="footer-link me-4">More Themes</a>

                  <a
                    href="https://themeselection.com/demo/sneat-bootstrap-html-admin-template/documentation/"
                    target="_blank"
                    class="footer-link me-4"
                    >Documentation</a
                  >

                  <a
                    href="https://github.com/themeselection/sneat-html-admin-template-free/issues"
                    target="_blank"
                    class="footer-link me-4"
                    >Support</a
                  >
                </div>
              </div>
            </footer>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../assets/vendor/libs/popper/popper.js"></script>
    <script src="../assets/vendor/js/bootstrap.js"></script>
    <script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="../assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->

    <!-- Main JS -->
    <script src="../assets/js/main.js"></script>

    <!-- Page JS -->

    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    
 




<script>
$(function(){
    let existingImages = [], newImages = [];

    function renderPreview() {
        const box = $('#previewBox').empty();
        [...existingImages, ...newImages].forEach(src=>{
            let imgSrc = src instanceof File ? URL.createObjectURL(src) : 'uploads/'+src;
            let wrapper = $('<div style="position:relative;"></div>');
            wrapper.append(`<img src="${imgSrc}" style="height:80px;border-radius:4px;">`);
            let rm = $('<span style="position:absolute;top:0;right:0;background:rgba(0,0,0,0.5);color:white;padding:2px 5px;cursor:pointer;">&times;</span>');
            rm.click(()=>{ 
                if(src instanceof File) newImages.splice(newImages.indexOf(src),1);
                else existingImages.splice(existingImages.indexOf(src),1);
                renderPreview();
            });
            wrapper.append(rm);
            box.append(wrapper);
        });
        box.toggleClass('d-none', existingImages.length+newImages.length===0);
    }

    $('#editProduct').on('show.bs.modal', function(e){
        const btn = $(e.relatedTarget);
        const form = $('#productForm')[0];
        form.id.value = btn.data('id');
        form.name.value = btn.data('name');
        form.price.value = btn.data('price');
        form.sell_price.value = btn.data('sell');
        form.distributor.value = btn.data('distributor');
        form.quantity.value = btn.data('quantity');
        form.details.value = btn.data('details');

        existingImages = btn.data('images') || [];
        newImages = [];
        $('#formFileMultiple').val('');
        renderPreview();
    });

    $('#formFileMultiple').on('change', function(){
        newImages.push(...this.files);
        renderPreview();
    });

    $('#productForm').on('submit', function(e){
        e.preventDefault();
        const btn = $(this).find('button[type="submit"]');
        const origText = btn.text();
        btn.prop('disabled', true).text('Saving...');

        const fd = new FormData(this);
        newImages.forEach(f => fd.append('images[]', f));
        fd.set('existing_images', JSON.stringify(existingImages));
        fd.set('action', 'products');

        $.ajax({
            url: '',
            type: 'POST',
            data: fd,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function(res){
                if(res.success){
                    $('#editProduct').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + (res.error||'Unknown'));
                    btn.prop('disabled', false).text(origText);
                }
            },
            error: function(xhr, status, error){
                console.log(xhr.responseText);
                alert('AJAX error: ' + error);
                btn.prop('disabled', false).text(origText);
            }
        });
    });
});
</script>
<script>
$(function(){
    let deleteId = null;

    // जब Delete बटन क्लिक हो
    $('#deleteModal').on('show.bs.modal', function (e) {
        const btn = $(e.relatedTarget);
        deleteId = btn.data('id');
        $('#deleteName').text(btn.data('name'));
        $('#deleteSpinner').addClass('d-none');
        $('#confirmDeleteBtn').prop('disabled', false);
    });

    // Yes पर क्लिक
    $('#confirmDeleteBtn').on('click', function () {
    if (!deleteId) return;

    // ✅ Yes बटन छुपाओ और स्पिनर दिखाओ
    $('#confirmDeleteBtn').addClass('d-none');
    $('#deleteSpinner').removeClass('d-none');

    $.ajax({
        url: '', // same page
        type: 'POST',
        dataType: 'json',
        data: {action: 'delete_product', id: deleteId},
        success: function (res) {
            if (res.success) {
                $('#deleteModal').modal('hide');
                location.reload();
            } else {
                alert('Delete failed: ' + (res.error || 'Unknown error'));
                // ❌ एरर पर फिर से Yes बटन दिखाओ और spinner हटाओ
                $('#confirmDeleteBtn').removeClass('d-none');
                $('#deleteSpinner').addClass('d-none');
            }
        },
        error: function (xhr, status, error) {
            alert('AJAX error: ' + error);
            $('#confirmDeleteBtn').removeClass('d-none');
            $('#deleteSpinner').addClass('d-none');
        }
    });
});
});
</script>


  </body>
</html>
