<?php
// admin/login.php
session_start();
require_once __DIR__ . '/../inc/db.php';

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($email && $password) {
        $stmt = $conn->prepare("SELECT id, name, password FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $res = $stmt->get_result();
        $user = $res->fetch_assoc();
        $stmt->close();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['admin_id'] = $user['id'];
            $_SESSION['admin_name'] = $user['name'];
            header('Location: dashboard.php');
            exit;
        } else {
            $msg = "Invalid credentials";
        }
    } else {
        $msg = "Please enter email and password";
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Admin Login</title></head>
<body>
  <h2>Admin Login</h2>
  <?php if($msg) echo "<p style='color:red;'>".htmlspecialchars($msg)."</p>"; ?>
  <form method="post">
    <label>Email</label><br>
    <input type="email" name="email" required><br><br>
    <label>Password</label><br>
    <input type="password" name="password" required><br><br>
    <button type="submit">Login</button>
  </form>
</body>
</html>
