<?php
// api/profile.php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/functions.php';

// try Bearer token first
$token = get_bearer_token();
if (!$token) {
    $data = get_post_data();
    $token = $data['api_token'] ?? '';
}
if (!$token) send_json(['status'=>false,'msg'=>'API token required']);

$stmt = $conn->prepare("SELECT id, name, email, created_at FROM users WHERE api_token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$res = $stmt->get_result();
$user = $res->fetch_assoc();
$stmt->close();

if (!$user) send_json(['status'=>false,'msg'=>'Invalid token']);

send_json(['status'=>true,'data'=>$user]);
?>
