# Kumawat Computer API Documentation

This API provides endpoints for the Kumawat Computer Flutter application, covering authentication, customer management, product management, invoice generation, and dashboard statistics.

## Base URL
```
http://your-domain.com/shopkumawat/api/
```

## Authentication
Most endpoints require authentication using Bearer token in the Authorization header:
```
Authorization: Bearer your_api_token_here
```

## API Endpoints

### Authentication

#### Login
- **POST** `/auth/login.php`
- **Body:**
  ```json
  {
    "email_username": "user@example.com",
    "password": "password123"
  }
  ```
- **Response:**
  ```json
  {
    "status": true,
    "message": "Login successful",
    "data": {
      "user": {
        "id": 1,
        "name": "John Doe",
        "email": "user@example.com",
        "api_token": "abc123..."
      },
      "token": "abc123..."
    }
  }
  ```

#### Register
- **POST** `/auth/register.php`
- **Body:**
  ```json
  {
    "name": "John Doe",
    "email": "user@example.com",
    "password": "password123",
    "confirm_password": "password123"
  }
  ```

#### Logout
- **POST** `/auth/logout.php`
- **Headers:** Authorization required

#### Get Profile
- **GET** `/auth/profile.php`
- **Headers:** Authorization required

#### Update Profile
- **PUT** `/auth/update_profile.php`
- **Headers:** Authorization required
- **Body:**
  ```json
  {
    "name": "John Doe",
    "email": "user@example.com",
    "phone": "1234567890",
    "mobile": "9876543210",
    "address": "123 Main St",
    "instagram": "@johndoe",
    "facebook": "johndoe"
  }
  ```

### Customer Management

#### Permanent Customers
- **GET** `/customers/permanent_customers.php` - Get all permanent customers
- **POST** `/customers/permanent_customers.php` - Add new permanent customer
- **PUT** `/customers/permanent_customers.php` - Update permanent customer
- **DELETE** `/customers/permanent_customers.php` - Delete permanent customer

#### Temporary Customers
- **GET** `/customers/temporary_customers.php` - Get all temporary customers
- **POST** `/customers/temporary_customers.php` - Add new temporary customer
- **PUT** `/customers/temporary_customers.php` - Update temporary customer
- **DELETE** `/customers/temporary_customers.php` - Delete temporary customer

#### Customer Details
- **GET** `/customers/customer_details.php?customer_id=1&type=permanent`
- **Headers:** Authorization required

### Product Management

#### Products
- **GET** `/products/products.php` - Get all products (with search and pagination)
- **POST** `/products/products.php` - Add new product
- **PUT** `/products/products.php` - Update product
- **DELETE** `/products/products.php` - Delete product

#### Product Details
- **GET** `/products/product_details.php?product_id=1`
- **Headers:** Authorization required

#### Upload Product Image
- **POST** `/products/upload_image.php`
- **Headers:** Authorization required
- **Body:** Form data with `image` file

### Invoice Management

#### Invoices
- **GET** `/invoices/invoices.php` - Get all invoices (with filters)
- **POST** `/invoices/invoices.php` - Create new invoice
- **PUT** `/invoices/invoices.php` - Update invoice status

#### Invoice Details
- **GET** `/invoices/invoice_details.php?invoice_id=1`
- **Headers:** Authorization required

#### Generate PDF
- **GET** `/invoices/generate_pdf.php?invoice_id=1`
- **Headers:** Authorization required

### User Management

#### Upload Profile Image
- **POST** `/user/upload_profile_image.php`
- **Headers:** Authorization required
- **Body:** Form data with `profile_image` file

### Dashboard

#### Statistics
- **GET** `/dashboard/stats.php`
- **Headers:** Authorization required
- **Response:**
  ```json
  {
    "status": true,
    "message": "Dashboard statistics retrieved successfully",
    "data": {
      "total_products": 150,
      "total_customers": 75,
      "total_invoices": 200,
      "total_revenue": 50000,
      "recent_invoices": [...],
      "low_stock_products": [...],
      "monthly_revenue": [...],
      "top_selling_products": [...]
    }
  }
  ```

## Error Responses

All endpoints return consistent error responses:
```json
{
  "status": false,
  "message": "Error description",
  "data": null
}
```

## HTTP Status Codes

- `200` - Success
- `400` - Bad Request (validation errors)
- `401` - Unauthorized (invalid/missing token)
- `404` - Not Found
- `405` - Method Not Allowed
- `409` - Conflict (duplicate data)
- `500` - Internal Server Error

## Database Tables

The API works with the following database tables:
- `users` - User accounts
- `products` - Product catalog
- `permanentcustomer` - Permanent customers
- `customers` - Temporary customers
- `invoices` - Invoice records
- `invoice_items` - Invoice line items

## File Uploads

- Product images: `/kumawat/uploads/`
- Profile images: `/kumawat/uploads/profile/`
- Invoice PDFs: `/kumawat/uploads/invoices/`

## CORS Support

The API includes CORS headers to support cross-origin requests from Flutter applications.

## Rate Limiting

Currently no rate limiting is implemented. Consider adding rate limiting for production use.

## Security Notes

- All passwords are hashed using PHP's `password_hash()` function
- API tokens are generated using `random_bytes()`
- Input validation and sanitization is performed on all endpoints
- SQL injection protection using prepared statements
- File upload validation for type and size
