<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Only POST method allowed', null, 405);
}

try {
    $user = validateToken($conn);
    
    // Clear the API token
    $stmt = $conn->prepare("UPDATE users SET api_token = NULL WHERE id = ?");
    $stmt->bind_param("i", $user['id']);
    
    if ($stmt->execute()) {
        sendResponse(true, 'Logout successful');
    } else {
        sendResponse(false, 'Logout failed', null, 500);
    }
    
    $stmt->close();
} catch (Exception $e) {
    sendResponse(false, 'Logout failed: ' . $e->getMessage(), null, 500);
}
?>
