<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendResponse(false, 'Only GET method allowed', null, 405);
}

try {
    $user = validateToken($conn);
    
    // Get full user profile
    $stmt = $conn->prepare("SELECT id, name, email, phone, mobile, address, instagram, facebook, profile_image, created_at FROM users WHERE id = ?");
    $stmt->bind_param("i", $user['id']);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($profile = $result->fetch_assoc()) {
        sendResponse(true, 'Profile retrieved successfully', $profile);
    } else {
        sendResponse(false, 'Profile not found', null, 404);
    }
    
    $stmt->close();
} catch (Exception $e) {
    sendResponse(false, 'Failed to get profile: ' . $e->getMessage(), null, 500);
}
?>
