<?php
require_once '../config.php';

try {
    $user = validateToken($conn);
    
    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        // Get all permanent customers
        $stmt = $conn->prepare("SELECT * FROM permanentcustomer ORDER BY id DESC");
        $stmt->execute();
        $result = $stmt->get_result();
        
        $customers = [];
        while ($row = $result->fetch_assoc()) {
            $customers[] = $row;
        }
        
        sendResponse(true, 'Permanent customers retrieved successfully', $customers);
        
    } elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Add new permanent customer
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input) {
            $input = $_POST;
        }
        
        $name = sanitizeInput($input['name'] ?? '');
        
        if (empty($name)) {
            sendResponse(false, 'Customer name is required', null, 400);
        }
        
        $stmt = $conn->prepare("INSERT INTO permanentcustomer (name) VALUES (?)");
        $stmt->bind_param("s", $name);
        
        if ($stmt->execute()) {
            $customerId = $conn->insert_id;
            sendResponse(true, 'Permanent customer added successfully', [
                'id' => $customerId,
                'name' => $name
            ]);
        } else {
            sendResponse(false, 'Failed to add permanent customer', null, 500);
        }
        
    } elseif ($_SERVER['REQUEST_METHOD'] === 'PUT') {
        // Update permanent customer
        $input = json_decode(file_get_contents('php://input'), true);
        
        $id = intval($input['id'] ?? 0);
        $name = sanitizeInput($input['name'] ?? '');
        
        if (empty($id) || empty($name)) {
            sendResponse(false, 'Customer ID and name are required', null, 400);
        }
        
        $stmt = $conn->prepare("UPDATE permanentcustomer SET name = ? WHERE id = ?");
        $stmt->bind_param("si", $name, $id);
        
        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                sendResponse(true, 'Permanent customer updated successfully', [
                    'id' => $id,
                    'name' => $name
                ]);
            } else {
                sendResponse(false, 'Customer not found', null, 404);
            }
        } else {
            sendResponse(false, 'Failed to update permanent customer', null, 500);
        }
        
    } elseif ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
        // Delete permanent customer
        $input = json_decode(file_get_contents('php://input'), true);
        
        $id = intval($input['id'] ?? 0);
        
        if (empty($id)) {
            sendResponse(false, 'Customer ID is required', null, 400);
        }
        
        $stmt = $conn->prepare("DELETE FROM permanentcustomer WHERE id = ?");
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                sendResponse(true, 'Permanent customer deleted successfully');
            } else {
                sendResponse(false, 'Customer not found', null, 404);
            }
        } else {
            sendResponse(false, 'Failed to delete permanent customer', null, 500);
        }
    } else {
        sendResponse(false, 'Method not allowed', null, 405);
    }
    
} catch (Exception $e) {
    sendResponse(false, 'Operation failed: ' . $e->getMessage(), null, 500);
}
?>
