<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: auth-basic-signin.php");
    exit();
}

require_once __DIR__ . '/../inc/db.php';

$user_id = $_SESSION['user_id'];

// Fetch user data
$sql = "SELECT name, email, phone, mobile, address, instagram, facebook, profile_image 
        FROM users WHERE id=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Get all products for selection
$products = [];
$result = $conn->query("SELECT * FROM products ORDER BY name ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }
}

// Get all customers for selection
$customers = [];
$result = $conn->query("SELECT * FROM customers ORDER BY name ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $customers[] = $row;
    }
}

$permanent_customers = [];
$result = $conn->query("SELECT * FROM permanentcustomer ORDER BY name ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $permanent_customers[] = $row;
    }
}

$party_customers = [];
$result = $conn->query("SELECT * FROM partycustomer ORDER BY name ASC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $party_customers[] = $row;
    }
}
?>

<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="assets/images/logo-icon.png" type="image/png" />
    <!--plugins-->
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <!-- loader-->
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/app.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    
    <title>Sell & Purchase Selection - Kumawat Computer</title>
</head>

<body class="bg-theme bg-theme2">
    <!--wrapper-->
    <div class="wrapper">
        <!--sidebar wrapper -->
        <div class="sidebar-wrapper" data-simplebar="true">
            <div class="sidebar-header">
                <div>
                    <img src="assets/images/logo-icon.png" class="logo-icon" alt="logo icon">
                </div>
                <div>
                    <h4 class="logo-text">Kumawat</h4>
                </div>
                <div class="toggle-icon ms-auto"><i class='bx bx-arrow-back'></i>
                </div>
             </div>
            <!--navigation-->
            <ul class="metismenu" id="menu">
                <li>
                    <a href="index.php">
                        <div class="parent-icon"><i class='bx bx-home-alt'></i>
                        </div>
                        <div class="menu-title">Home</div>
                    </a> 
                </li>  
                <li>
                    <a href="table-datatable.php">
                        <div class="parent-icon"><i class="bx bx-grid-alt"></i>
                        </div>
                        <div class="menu-title">Product Tables</div>
                    </a> 
                </li>
              
                <li>
                    <a href="ecommerce-products.php">
                        <div class="parent-icon"><i class='bx bx-briefcase-alt'></i>
                        </div>
                        <div class="menu-title">Products</div>
                    </a> 
                </li>  
                <li>
                    <a href="ecommerce-add-new-products.php">
                        <div class="parent-icon"><i class='bx bx-store'></i>
                        </div>
                        <div class="menu-title">Add New Products</div>
                    </a> 
                </li> 
                <li>
                    <a href="temprary.php">
                        <div class="parent-icon"><i class='bx bx-repeat'></i>
                        </div>
                        <div class="menu-title">Temporary</div>
                    </a> 
                </li> 
                <li>
                    <a href="permanent-customer.php">
                        <div class="parent-icon"><i class='bx bx-bookmark-heart'></i>
                        </div>
                        <div class="menu-title">Permanent Customer</div>
                    </a> 
                </li>
                <li>
                    <a href="party-customer.php">
                        <div class="parent-icon"><i class='bx bx-cookie'></i>
                        </div>
                        <div class="menu-title">Party</div>
                    </a> 
                </li>
                <li>
                    <a href="sell-purchase-selection.php" class="mm-active">
                        <div class="parent-icon"><i class='bx bx-transfer'></i>
                        </div>
                        <div class="menu-title">Sell & Purchase</div>
                    </a> 
                </li>
                <li>
                    <a href="sell-purchase-reports.php">
                        <div class="parent-icon"><i class='bx bx-bar-chart-alt-2'></i>
                        </div>
                        <div class="menu-title">Sell & Purchase Reports</div>
                    </a> 
                </li>
                <li>
                    <a href="ecommerce-orders.php">
                        <div class="parent-icon"><i class='bx bx-cart'></i>
                        </div>
                        <div class="menu-title">History</div>
                    </a> 
                </li> 
                <li>
                    <a href="user-profile.php">
                        <div class="parent-icon"><i class="bx bx-user-circle"></i>
                        </div>
                        <div class="menu-title">User Profile</div>
                    </a>
                </li>  
            </ul>
            <!--end navigation-->
        </div>
        <!--end sidebar wrapper -->
        <!--start header -->
        <header>
            <div class="topbar d-flex align-items-center">
                <nav class="navbar navbar-expand gap-3">
                    <div class="mobile-toggle-menu"><i class='bx bx-menu'></i>
                    </div>
                    <div class="search-bar flex-grow-1">
                        <div class="position-relative search-bar-box">
                            <input type="text" class="form-control search-control" placeholder="Type to search..."> <span class="position-absolute top-50 search-show translate-middle-y"><i class='bx bx-search'></i></span>
                            <span class="position-absolute top-50 search-close translate-middle-y"><i class='bx bx-x'></i></span>
                        </div>
                    </div>
                    <div class="top-menu ms-auto">
                        <ul class="navbar-nav align-items-center gap-1">
                            <li class="nav-item mobile-search-icon d-flex d-lg-none" data-bs-toggle="modal" data-bs-target="#SearchModal">
                                <a class="nav-link" href="avascript:;"><i class='bx bx-search'></i>
                                </a>
                            </li>  
                        </ul>
                    </div>
                    <div class="user-box dropdown px-3">
                        <a class="d-flex align-items-center nav-link dropdown-toggle gap-3 dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="<?= htmlspecialchars($user['profile_image'] ?: 'assets/images/avatars/avatar-2.png') ?>"
                                             alt="Profile" class="user-img">
                            <div class="user-info">
                                <p class="user-name mb-0"><?= htmlspecialchars($user['name']) ?></p>
                                <p class="designattion mb-0"><?= htmlspecialchars($user['email']) ?></p>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item d-flex align-items-center" href="user-profile.php"><i class="bx bx-user fs-5"></i><span>Profile</span></a>
                            </li> 
                            <li>
                                <div class="dropdown-divider mb-0"></div>
                            </li>
                            <li><a class="dropdown-item d-flex align-items-center" href="logout.php"><i class="bx bx-log-out-circle"></i><span>Logout</span></a>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </header>
        <!--end header -->
        <!--start page wrapper -->
        <div class="page-wrapper">
            <div class="page-content">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Sell & Purchase Selection</h4>
                                <hr>
                                
                                <!-- Selection Cards -->
                                <div class="row">
                                    <!-- Sell Operations -->
                                    <div class="col-md-6">
                                        <div class="card border-success">
                                            <div class="card-header bg-success text-white">
                                                <h5 class="card-title mb-0"><i class="bx bx-trending-up"></i> Sell Operations</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <a href="temprary.php" class="btn btn-outline-success w-100">
                                                            <i class="bx bx-repeat"></i><br>
                                                            <strong>Temporary Customer</strong><br>
                                                            <small>Quick Sale</small>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <a href="permanent-customer.php" class="btn btn-outline-success w-100">
                                                            <i class="bx bx-bookmark-heart"></i><br>
                                                            <strong>Permanent Customer</strong><br>
                                                            <small>Regular Customer</small>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <a href="party-customer.php" class="btn btn-outline-success w-100">
                                                            <i class="bx bx-cookie"></i><br>
                                                            <strong>Party Customer</strong><br>
                                                            <small>Bulk Sale</small>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <a href="ecommerce-orders.php" class="btn btn-outline-info w-100">
                                                            <i class="bx bx-history"></i><br>
                                                            <strong>Sale History</strong><br>
                                                            <small>View Records</small>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Purchase Operations -->
                                    <div class="col-md-6">
                                        <div class="card border-warning">
                                            <div class="card-header bg-warning text-dark">
                                                <h5 class="card-title mb-0"><i class="bx bx-trending-down"></i> Purchase Operations</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <a href="ecommerce-add-new-products.php" class="btn btn-outline-warning w-100">
                                                            <i class="bx bx-plus-circle"></i><br>
                                                            <strong>Add Products</strong><br>
                                                            <small>New Inventory</small>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <a href="ecommerce-products.php" class="btn btn-outline-warning w-100">
                                                            <i class="bx bx-package"></i><br>
                                                            <strong>Manage Products</strong><br>
                                                            <small>Update Stock</small>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <a href="table-datatable.php" class="btn btn-outline-warning w-100">
                                                            <i class="bx bx-table"></i><br>
                                                            <strong>Product Tables</strong><br>
                                                            <small>View All Products</small>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <a href="sell-purchase-reports.php" class="btn btn-outline-info w-100">
                                                            <i class="bx bx-bar-chart-alt-2"></i><br>
                                                            <strong>Purchase Reports</strong><br>
                                                            <small>Analytics</small>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Quick Stats -->
                                <div class="row mt-4">
                                    <div class="col-md-3">
                                        <div class="card border-primary">
                                            <div class="card-body text-center">
                                                <i class="bx bx-package text-primary" style="font-size: 2rem;"></i>
                                                <h5 class="mt-2"><?= count($products) ?></h5>
                                                <p class="text-muted mb-0">Total Products</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-success">
                                            <div class="card-body text-center">
                                                <i class="bx bx-repeat text-success" style="font-size: 2rem;"></i>
                                                <h5 class="mt-2"><?= count($customers) ?></h5>
                                                <p class="text-muted mb-0">Temporary Customers</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-info">
                                            <div class="card-body text-center">
                                                <i class="bx bx-bookmark-heart text-info" style="font-size: 2rem;"></i>
                                                <h5 class="mt-2"><?= count($permanent_customers) ?></h5>
                                                <p class="text-muted mb-0">Permanent Customers</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-warning">
                                            <div class="card-body text-center">
                                                <i class="bx bx-cookie text-warning" style="font-size: 2rem;"></i>
                                                <h5 class="mt-2"><?= count($party_customers) ?></h5>
                                                <p class="text-muted mb-0">Party Customers</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Quick Actions -->
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <h5 class="card-title mb-0">Quick Actions</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-md-4 mb-3">
                                                        <a href="sell-purchase-reports.php" class="btn btn-primary w-100">
                                                            <i class="bx bx-bar-chart-alt-2"></i> View Reports
                                                        </a>
                                                    </div>
                                                    <div class="col-md-4 mb-3">
                                                        <a href="ecommerce-orders.php" class="btn btn-info w-100">
                                                            <i class="bx bx-history"></i> Transaction History
                                                        </a>
                                                    </div>
                                                    <div class="col-md-4 mb-3">
                                                        <a href="user-profile.php" class="btn btn-secondary w-100">
                                                            <i class="bx bx-user"></i> Profile Settings
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--end page wrapper -->
        <!--start overlay-->
        <div class="overlay toggle-icon"></div>
        <!--end overlay-->
        <!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
        <!--End Back To Top Button-->
        <footer class="page-footer">
            <p class="mb-0">Copyright © 2021. All right reserved.</p>
        </footer>
    </div>
    <!--end wrapper-->
    <!--start switcher-->
    <div class="switcher-wrapper">
        <div class="switcher-btn"> <i class='bx bx-cog bx-spin'></i>
        </div>
        <div class="switcher-body">
            <div class="d-flex align-items-center">
                <h5 class="mb-0 text-uppercase">Theme Customizer</h5>
                <button type="button" class="btn-close ms-auto close-switcher" aria-label="Close"></button>
            </div>
            <hr/>
            <p class="mb-0">Gaussian Texture</p>
            <hr>
            <ul class="switcher">
                <li id="theme1"></li>
                <li id="theme2"></li>
                <li id="theme3"></li>
                <li id="theme4"></li>
                <li id="theme5"></li>
                <li id="theme6"></li>
            </ul>
            <hr>
            <p class="mb-0">Gradient Background</p>
            <hr>
            <ul class="switcher">
                <li id="theme7"></li>
                <li id="theme8"></li>
                <li id="theme9"></li>
                <li id="theme10"></li>
                <li id="theme11"></li>
                <li id="theme12"></li>
                <li id="theme13"></li>
                <li id="theme14"></li>
                <li id="theme15"></li>
              </ul>
        </div>
    </div>
    <!--end switcher-->
    <!-- Bootstrap JS -->
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <!--plugins-->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
    <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
    <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
    <script src="assets/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
    <script src="assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="assets/js/index.js"></script>
    <!--app JS-->
    <script src="assets/js/app.js"></script>
</body>
</html>
