# Student Management System

A comprehensive PHP-based student management system with modern UI and professional features.

## Features

### Core Features
- **Student Management**: Add, edit, view, and delete student records
- **Admin Authentication**: Secure login system for administrators
- **Fee Management**: Track total fees, deposits, and pending amounts
- **Search & Filter**: Find students quickly with search functionality
- **Responsive Design**: Works on desktop, tablet, and mobile devices

### Student Information
- Student Name, Father's Name, Mother's Name
- Date of Birth, Gender, Joining Date
- Contact Information (Phone, Email, Address, Emergency Contact)
- Fee Information (Total Fee, Deposited Amount, Auto-calculated Pending)
- Student Status (Active, Inactive, Graduated)
- Auto-generated Student ID

### Professional Features
- **Dashboard Analytics**: Statistics and overview of student data
- **Reports & Charts**: Visual representation of data with Chart.js
- **Toast Notifications**: User-friendly feedback messages
- **Data Tables**: Sortable and searchable student lists
- **Profile Management**: Admin profile and password management
- **System Information**: Application and database status

## Installation

### Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- Modern web browser

### Setup Instructions

1. **Clone/Download the project**
   ```bash
   git clone <repository-url>
   # or download and extract the ZIP file
   ```

2. **Database Setup**
   - Create a MySQL database named `student_management`
   - Import the database schema:
     ```bash
     mysql -u root -p student_management < database/schema.sql
     ```

3. **Configuration**
   - Update database credentials in `config/database.php` if needed:
     ```php
     private $host = "localhost";
     private $db_name = "student_management";
     private $username = "root";
     private $password = "";
     ```

4. **Web Server Setup**
   - Place the project files in your web server directory
   - Ensure the web server has read/write permissions
   - Update `BASE_URL` in `config/config.php` if needed

5. **Access the Application**
   - Open your web browser
   - Navigate to your project URL
   - Default admin credentials:
     - Username: `admin`
     - Password: `admin123`

## File Structure

```
project/
├── config/
│   ├── config.php          # Application configuration
│   └── database.php        # Database connection
├── models/
│   ├── Admin.php           # Admin model
│   └── Student.php         # Student model
├── database/
│   └── schema.sql          # Database schema
├── index.php               # Main dashboard
├── login.php               # Admin login page
├── logout.php              # Logout handler
├── add_student.php         # Add new student
├── edit_student.php        # Edit student details
├── view_student.php        # View student details
├── reports.php             # Reports and analytics
├── settings.php            # Admin settings
└── README.md               # This file
```

## Usage

### Admin Login
1. Navigate to the login page
2. Enter admin credentials
3. Access the dashboard

### Managing Students
1. **Add Student**: Click "Add Student" button, fill in the form
2. **View Students**: Browse the student list on the dashboard
3. **Edit Student**: Click the edit button next to any student
4. **Delete Student**: Click the delete button (with confirmation)
5. **Search Students**: Use the search box to find specific students

### Reports
- View student statistics and analytics
- Monitor fee collection progress
- Track monthly registrations
- Review recent student additions

### Settings
- Update admin profile information
- Change admin password
- View system information

## Security Features

- Password hashing using PHP's `password_hash()`
- SQL injection prevention with prepared statements
- Input sanitization and validation
- Session management
- Admin-only access control

## Browser Support

- Chrome 60+
- Firefox 55+
- Safari 12+
- Edge 79+

## Technologies Used

- **Backend**: PHP 7.4+, MySQL
- **Frontend**: HTML5, CSS3, JavaScript
- **UI Framework**: Bootstrap 5
- **Icons**: Font Awesome 6
- **Charts**: Chart.js
- **Data Tables**: DataTables

## Customization

### Adding New Fields
1. Update the database schema in `database/schema.sql`
2. Modify the Student model in `models/Student.php`
3. Update the forms in `add_student.php` and `edit_student.php`
4. Update the display in `index.php` and `view_student.php`

### Styling
- Modify CSS in the `<style>` sections of each page
- Update Bootstrap classes for different layouts
- Customize the color scheme by changing the gradient values

### Database Configuration
- Update connection details in `config/database.php`
- Modify table names or structure as needed
- Add indexes for better performance

## Troubleshooting

### Common Issues

1. **Database Connection Error**
   - Check database credentials in `config/database.php`
   - Ensure MySQL service is running
   - Verify database exists

2. **Permission Errors**
   - Check file permissions
   - Ensure web server has read access
   - Verify directory permissions

3. **Login Issues**
   - Reset admin password in database
   - Check session configuration
   - Clear browser cache

4. **Display Issues**
   - Check internet connection for CDN resources
   - Verify Bootstrap and Font Awesome are loading
   - Check browser console for JavaScript errors

## Support

For support and questions:
- Check the troubleshooting section
- Review the code comments
- Ensure all prerequisites are met
- Verify file permissions and database setup

## License

This project is open source and available under the MIT License.

## Version History

- **v1.0.0**: Initial release with core features
  - Student management CRUD operations
  - Admin authentication
  - Dashboard and reports
  - Responsive design
  - Professional UI/UX
