<?php
require_once 'config/config.php';
require_once 'config/database.php';
require_once 'models/Student.php';

requireLogin();

$database = new Database();
$db = $database->getConnection();
$student = new Student($db);

$error_message = '';
$success_message = '';

if ($_POST) {
    // Sanitize input data
    $student->student_name = sanitizeInput($_POST['student_name']);
    $student->fathers_name = sanitizeInput($_POST['fathers_name']);
    $student->mothers_name = sanitizeInput($_POST['mothers_name']);
    $student->date_of_birth = $_POST['date_of_birth'];
    $student->gender = $_POST['gender'];
    $student->joining_date = $_POST['joining_date'];
    $student->total_fee = floatval($_POST['total_fee']);
    $student->contact_number = sanitizeInput($_POST['contact_number']);
    $student->email = sanitizeInput($_POST['email']);
    $student->address = sanitizeInput($_POST['address']);
    $student->emergency_contact = sanitizeInput($_POST['emergency_contact']);
    $student->student_id = generateStudentId();
    $student->status = $_POST['status'];
    $student->reference_name = sanitizeInput($_POST['reference_name']);
    $student->exit_date = !empty($_POST['exit_date']) ? $_POST['exit_date'] : null;
    $student->document_name = $_POST['document_name'];

    // Validation
    if (empty($student->student_name) || empty($student->fathers_name) || empty($student->mothers_name)) {
        $error_message = 'Please fill in all required fields!';
    } else {
        if ($student->create()) {
            $_SESSION['success_message'] = 'Student added successfully!';
            redirect('index.php');
        } else {
            $error_message = 'Failed to add student. Please try again!';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Student - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 2px 0;
            transition: all 0.3s ease;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        .main-content {
            background-color: #f8f9fa;
            min-height: 100vh;
        }
        .form-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            overflow: hidden;
        }
        .form-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1.5rem;
        }
        .form-control, .form-select {
            border-radius: 8px;
            border: 2px solid #e9ecef;
            padding: 10px 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .required {
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="p-3">
                        <h4 class="text-center mb-4">
                            <i class="fas fa-graduation-cap me-2"></i>
                            <?php echo APP_NAME; ?>
                        </h4>
                        <nav class="nav flex-column">
                            <a class="nav-link" href="index.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                            <a class="nav-link active" href="add_student.php">
                                <i class="fas fa-user-plus me-2"></i>Add Student
                            </a>
                            <a class="nav-link" href="reports.php">
                                <i class="fas fa-chart-bar me-2"></i>Reports
                            </a>
                            <a class="nav-link" href="settings.php">
                                <i class="fas fa-cog me-2"></i>Settings
                            </a>
                            <hr class="my-3">
                            <a class="nav-link" href="logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                            </a>
                        </nav>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Top Navigation -->
                    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
                        <div class="container-fluid">
                            <span class="navbar-brand mb-0 h1">Add New Student</span>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Welcome, <?php echo $_SESSION['admin_name']; ?></span>
                                <div class="dropdown">
                                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-user-circle"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i>Profile</a></li>
                                        <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog me-2"></i>Settings</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </nav>

                    <div class="p-4">
                        <div class="row justify-content-center">
                            <div class="col-lg-8">
                                <div class="form-container">
                                    <div class="form-header">
                                        <h4 class="mb-0">
                                            <i class="fas fa-user-plus me-2"></i>Add New Student
                                        </h4>
                                        <p class="mb-0">Fill in the student details below</p>
                                    </div>

                                    <div class="p-4">
                                        <?php if ($error_message): ?>
                                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                <?php echo $error_message; ?>
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                            </div>
                                        <?php endif; ?>

                                        <form method="POST" action="">
                                            <div class="row">
                                                <!-- Personal Information -->
                                                <div class="col-12">
                                                    <h6 class="text-primary mb-3">
                                                        <i class="fas fa-user me-2"></i>Personal Information
                                                    </h6>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="student_name" class="form-label">Student Name <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="student_name" name="student_name" 
                                                           value="<?php echo isset($_POST['student_name']) ? $_POST['student_name'] : ''; ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="fathers_name" class="form-label">Father's Name <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="fathers_name" name="fathers_name" 
                                                           value="<?php echo isset($_POST['fathers_name']) ? $_POST['fathers_name'] : ''; ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="mothers_name" class="form-label">Mother's Name <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="mothers_name" name="mothers_name" 
                                                           value="<?php echo isset($_POST['mothers_name']) ? $_POST['mothers_name'] : ''; ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="date_of_birth" class="form-label">Date of Birth <span class="required">*</span></label>
                                                    <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" 
                                                           value="<?php echo isset($_POST['date_of_birth']) ? $_POST['date_of_birth'] : ''; ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="gender" class="form-label">Gender <span class="required">*</span></label>
                                                    <select class="form-select" id="gender" name="gender" required>
                                                        <option value="">Select Gender</option>
                                                        <option value="Male" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'Male') ? 'selected' : ''; ?>>Male</option>
                                                        <option value="Female" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'Female') ? 'selected' : ''; ?>>Female</option>
                                                        <option value="Other" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="joining_date" class="form-label">Joining Date <span class="required">*</span></label>
                                                    <input type="date" class="form-control" id="joining_date" name="joining_date" 
                                                           value="<?php echo isset($_POST['joining_date']) ? $_POST['joining_date'] : date('Y-m-d'); ?>" required>
                                                </div>

                                                <!-- Contact Information -->
                                                <div class="col-12 mt-4">
                                                    <h6 class="text-primary mb-3">
                                                        <i class="fas fa-phone me-2"></i>Contact Information
                                                    </h6>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="contact_number" class="form-label">Contact Number</label>
                                                    <input type="tel" class="form-control" id="contact_number" name="contact_number" 
                                                           value="<?php echo isset($_POST['contact_number']) ? $_POST['contact_number'] : ''; ?>">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="email" class="form-label">Email Address</label>
                                                    <input type="email" class="form-control" id="email" name="email" 
                                                           value="<?php echo isset($_POST['email']) ? $_POST['email'] : ''; ?>">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="emergency_contact" class="form-label">Emergency Contact</label>
                                                    <input type="tel" class="form-control" id="emergency_contact" name="emergency_contact" 
                                                           value="<?php echo isset($_POST['emergency_contact']) ? $_POST['emergency_contact'] : ''; ?>">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="reference_name" class="form-label">Reference Name</label>
                                                    <input type="text" class="form-control" id="reference_name" name="reference_name" 
                                                           value="<?php echo isset($_POST['reference_name']) ? $_POST['reference_name'] : ''; ?>">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="document_name" class="form-label">Document Name</label>
                                                    <select class="form-select" id="document_name" name="document_name">
                                                        <option value="">Select Document</option>
                                                        <option value="10th Marksheet" <?php echo (isset($_POST['document_name']) && $_POST['document_name'] == '10th Marksheet') ? 'selected' : ''; ?>>10th Marksheet</option>
                                                        <option value="12th Marksheet" <?php echo (isset($_POST['document_name']) && $_POST['document_name'] == '12th Marksheet') ? 'selected' : ''; ?>>12th Marksheet</option>
                                                        <option value="Aadhar Card" <?php echo (isset($_POST['document_name']) && $_POST['document_name'] == 'Aadhar Card') ? 'selected' : ''; ?>>Aadhar Card</option>
                                                        <option value="Pan Card" <?php echo (isset($_POST['document_name']) && $_POST['document_name'] == 'Pan Card') ? 'selected' : ''; ?>>Pan Card</option>
                                                        <option value="Voter ID" <?php echo (isset($_POST['document_name']) && $_POST['document_name'] == 'Voter ID') ? 'selected' : ''; ?>>Voter ID</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="exit_date" class="form-label">Exit Date</label>
                                                    <input type="date" class="form-control" id="exit_date" name="exit_date" 
                                                           value="<?php echo isset($_POST['exit_date']) ? $_POST['exit_date'] : ''; ?>">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="status" class="form-label">Status</label>
                                                    <select class="form-select" id="status" name="status">
                                                        <option value="Active" <?php echo (isset($_POST['status']) && $_POST['status'] == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                        <option value="Inactive" <?php echo (isset($_POST['status']) && $_POST['status'] == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                                                        <option value="Graduated" <?php echo (isset($_POST['status']) && $_POST['status'] == 'Graduated') ? 'selected' : ''; ?>>Graduated</option>
                                                    </select>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label for="address" class="form-label">Address</label>
                                                    <textarea class="form-control" id="address" name="address" rows="3"><?php echo isset($_POST['address']) ? $_POST['address'] : ''; ?></textarea>
                                                </div>

                                                <!-- Fee Information -->
                                                <div class="col-12 mt-4">
                                                    <h6 class="text-primary mb-3">
                                                        <i class="fas fa-rupee-sign me-2"></i>Fee Information
                                                    </h6>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="total_fee" class="form-label">Total Fee <span class="required">*</span></label>
                                                    <input type="number" class="form-control" id="total_fee" name="total_fee" 
                                                           step="0.01" min="0" value="<?php echo isset($_POST['total_fee']) ? $_POST['total_fee'] : ''; ?>" required>
                                                </div>
                                            </div>

                                            <div class="d-flex justify-content-end mt-4">
                                                <a href="index.php" class="btn btn-secondary me-3">
                                                    <i class="fas fa-times me-2"></i>Cancel
                                                </a>
                                                <button type="submit" class="btn btn-primary btn-submit">
                                                    <i class="fas fa-save me-2"></i>Add Student
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Form validation
        document.getElementById('total_fee').addEventListener('input', function() {
            const totalFee = parseFloat(this.value) || 0;
            if (totalFee < 0) {
                this.setCustomValidity('Total fee cannot be negative');
            } else {
                this.setCustomValidity('');
            }
        });
    </script>
</body>
</html>
