<?php
// File structure checker
echo "<h2>Student Management System - File Check</h2>";
echo "<style>body{font-family:Arial;margin:20px;} .ok{color:green;} .error{color:red;} .warning{color:orange;}</style>";

$required_files = [
    'config/config.php',
    'config/database.php',
    'models/Student.php',
    'models/Admin.php',
    'database/schema.sql',
    'login.php',
    'add_student.php',
    'edit_student.php',
    'view_student.php',
    'reports.php',
    'settings.php',
    'install.php'
];

$required_dirs = [
    'config',
    'models',
    'database'
];

echo "<h3>Directory Check:</h3>";
foreach ($required_dirs as $dir) {
    if (is_dir($dir)) {
        echo "<div class='ok'>✓ Directory '$dir' exists</div>";
    } else {
        echo "<div class='error'>✗ Directory '$dir' missing</div>";
    }
}

echo "<h3>File Check:</h3>";
foreach ($required_files as $file) {
    if (file_exists($file)) {
        echo "<div class='ok'>✓ File '$file' exists</div>";
    } else {
        echo "<div class='error'>✗ File '$file' missing</div>";
    }
}

echo "<h3>PHP Configuration:</h3>";
echo "<div class='ok'>PHP Version: " . PHP_VERSION . "</div>";
echo "<div class='ok'>PDO Available: " . (extension_loaded('pdo') ? 'Yes' : 'No') . "</div>";
echo "<div class='ok'>PDO MySQL Available: " . (extension_loaded('pdo_mysql') ? 'Yes' : 'No') . "</div>";

echo "<h3>Database Connection Test:</h3>";
try {
    $pdo = new PDO("mysql:host=localhost", "root", "");
    echo "<div class='ok'>✓ Database connection successful</div>";
    
    // Check if database exists
    $stmt = $pdo->query("SHOW DATABASES LIKE 'student_management'");
    if ($stmt->rowCount() > 0) {
        echo "<div class='ok'>✓ Database 'student_management' exists</div>";
    } else {
        echo "<div class='warning'>⚠ Database 'student_management' does not exist - run install.php</div>";
    }
} catch (PDOException $e) {
    echo "<div class='error'>✗ Database connection failed: " . $e->getMessage() . "</div>";
}

echo "<h3>File Permissions:</h3>";
$test_file = 'permission_test.txt';
if (file_put_contents($test_file, 'test')) {
    echo "<div class='ok'>✓ Write permissions OK</div>";
    unlink($test_file);
} else {
    echo "<div class='error'>✗ Write permissions failed</div>";
}

echo "<h3>Session Test:</h3>";
session_start();
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "<div class='ok'>✓ Sessions working</div>";
} else {
    echo "<div class='error'>✗ Sessions not working</div>";
}

echo "<hr>";
echo "<p><a href='test.php'>Run Basic PHP Test</a> | <a href='install.php'>Run Installation</a></p>";
?>
