<?php
require_once 'config/config.php';
require_once 'config/database.php';

requireLogin();

$database = new Database();
$db = $database->getConnection();

// Get fee deposit ID from URL
$deposit_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($deposit_id <= 0) {
    die('Invalid deposit ID');
}

// Get fee deposit details
$query = "SELECT fh.*, s.student_name, s.fathers_name, s.mothers_name, s.contact_number, 
                 s.email, s.address, s.student_id, s.total_fee
          FROM fee_history fh 
          JOIN students s ON fh.student_id = s.id 
          WHERE fh.id = ?";
$stmt = $db->prepare($query);
$stmt->execute([$deposit_id]);
$deposit = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$deposit) {
    die('Deposit record not found');
}

// Get total deposited amount for this student
$total_deposited_query = "SELECT COALESCE(SUM(amount), 0) as total_deposited 
                          FROM fee_history 
                          WHERE student_id = ?";
$total_stmt = $db->prepare($total_deposited_query);
$total_stmt->execute([$deposit['student_id']]);
$total_deposited = $total_stmt->fetch(PDO::FETCH_ASSOC)['total_deposited'];

// Generate invoice number
$invoice_number = 'INV-' . date('Y') . '-' . str_pad($deposit_id, 4, '0', STR_PAD_LEFT);

// Get invoice settings from database
$settings_query = "SELECT setting_key, setting_value FROM invoice_settings";
$settings_stmt = $db->prepare($settings_query);
$settings_stmt->execute();
$settings_data = $settings_stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// School/Institution details from database
$school_name = $settings_data['school_name'] ?? "Student Management System";
$school_address = $settings_data['school_address'] ?? "Your School Address, City, State, PIN";
$school_contact = $settings_data['school_contact'] ?? "Phone: +91-XXXXXXXXXX | Email: info@yourschool.com";
$gstin = $settings_data['gstin'] ?? "22AAAAA0000A1Z5";
$bank_name = $settings_data['bank_name'] ?? "Your Bank Name";
$account_number = $settings_data['account_number'] ?? "XXXXXXXXXXXXXX";
$ifsc_code = $settings_data['ifsc_code'] ?? "XXXX0000000";
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Fee Deposit Receipt - <?php echo $invoice_number; ?></title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
            .print-button { display: none; }
        }
        
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 12px;
            line-height: 1.4;
            background-color: #f5f5f5;
        }
        
        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
            z-index: 1000;
        }
        
        .print-button:hover {
            background: #0056b3;
        }
        
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .school-name {
            font-size: 24px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }
        
        .school-address {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .school-contact {
            font-size: 12px;
            color: #666;
        }
        
        .invoice-details {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        
        .invoice-info {
            text-align: right;
        }
        
        .invoice-title {
            font-size: 20px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }
        
        .party-details {
            margin-bottom: 30px;
        }
        
        .party-section {
            margin-bottom: 15px;
        }
        
        .party-label {
            font-weight: bold;
            display: inline-block;
            width: 120px;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .items-table th,
        .items-table td {
            border: 1px solid #333;
            padding: 8px;
            text-align: left;
        }
        
        .items-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        
        .items-table .text-right {
            text-align: right;
        }
        
        .items-table .text-center {
            text-align: center;
        }
        
        .totals {
            margin-left: auto;
            width: 300px;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            padding: 5px 0;
        }
        
        .total-label {
            font-weight: bold;
        }
        
        .grand-total {
            border-top: 2px solid #333;
            padding-top: 10px;
            font-size: 16px;
            font-weight: bold;
        }
        
        .bank-details {
            margin-top: 30px;
            margin-bottom: 20px;
        }
        
        .bank-details h4 {
            margin-bottom: 10px;
            color: #333;
        }
        
        .terms {
            margin-top: 30px;
        }
        
        .terms h4 {
            margin-bottom: 10px;
            color: #333;
        }
        
        .terms ol {
            margin: 0;
            padding-left: 20px;
        }
        
        .footer {
            margin-top: 40px;
            text-align: center;
        }
        
        .signature {
            margin-top: 30px;
            text-align: right;
        }
        
        .seal {
            width: 100px;
            height: 100px;
            border: 2px solid #333;
            border-radius: 50%;
            margin: 20px auto;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            font-size: 10px;
            font-weight: bold;
        }
        
        .back-button {
            margin-bottom: 20px;
        }
        
        .back-button a {
            background: #6c757d;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
        }
        
        .back-button a:hover {
            background: #545b62;
        }
    </style>
</head>
<body>
    <button class="print-button" onclick="window.print()">🖨️ Print Receipt</button>
    
    <div class="invoice-container">
        <div class="back-button no-print">
            <a href="fee_deposit.php">← Back to Fee Deposit</a>
        </div>
        
        <div class="header">
            <div class="school-name"><?php echo $school_name; ?></div>
            <div class="school-address"><?php echo $school_address; ?></div>
            <div class="school-contact"><?php echo $school_contact; ?></div>
        </div>

        <div class="invoice-details">
            <div class="party-details">
                <div class="party-section">
                    <span class="party-label">Party Name:</span> <?php echo htmlspecialchars($deposit['student_name']); ?>
                </div>
                <div class="party-section">
                    <span class="party-label">Father's Name:</span> <?php echo htmlspecialchars($deposit['fathers_name']); ?>
                </div>
                <div class="party-section">
                    <span class="party-label">Student ID:</span> <?php echo htmlspecialchars($deposit['student_id']); ?>
                </div>
                <div class="party-section">
                    <span class="party-label">Contact:</span> <?php echo htmlspecialchars($deposit['contact_number']); ?>
                </div>
                <div class="party-section">
                    <span class="party-label">Address:</span> <?php echo htmlspecialchars($deposit['address']); ?>
                </div>
            </div>
            
            <div class="invoice-info">
                <div class="invoice-title">FEE DEPOSIT RECEIPT</div>
                <div><strong>Receipt No:</strong> <?php echo $invoice_number; ?></div>
                <div><strong>Date:</strong> <?php echo date('d-m-Y', strtotime($deposit['payment_date'])); ?></div>
                <div><strong>GSTIN:</strong> <?php echo $gstin; ?></div>
            </div>
        </div>

        <table class="items-table">
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Student ID</th>
                    <th>Payment Date</th>
                    <th>Payment Method</th>
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Fee Deposit - <?php echo htmlspecialchars($deposit['student_name']); ?></td>
                    <td class="text-center"><?php echo htmlspecialchars($deposit['student_id']); ?></td>
                    <td class="text-center"><?php echo date('d-m-Y', strtotime($deposit['payment_date'])); ?></td>
                    <td class="text-center"><?php echo htmlspecialchars($deposit['payment_method']); ?></td>
                    <td class="text-right">₹<?php echo number_format($deposit['amount'], 2); ?></td>
                </tr>
            </tbody>
        </table>

        <div class="totals">
            <div class="total-row">
                <span class="total-label">Total Fee:</span>
                <span>₹<?php echo number_format($deposit['total_fee'], 2); ?></span>
            </div>
            <div class="total-row">
                <span class="total-label">Total Deposited:</span>
                <span>₹<?php echo number_format($total_deposited, 2); ?></span>
            </div>
            <div class="total-row">
                <span class="total-label">This Deposit:</span>
                <span>₹<?php echo number_format($deposit['amount'], 2); ?></span>
            </div>
            <div class="total-row">
                <span class="total-label">Pending Amount:</span>
                <span>₹<?php echo number_format($deposit['total_fee'] - $total_deposited, 2); ?></span>
            </div>
            <div class="total-row grand-total">
                <span class="total-label">Amount Received:</span>
                <span>₹<?php echo number_format($deposit['amount'], 2); ?></span>
            </div>
        </div>

        <div class="bank-details">
            <h4>Bank Details:</h4>
            <div><strong>Bank Name:</strong> <?php echo $bank_name; ?></div>
            <div><strong>Account Number:</strong> <?php echo $account_number; ?></div>
            <div><strong>IFSC Code:</strong> <?php echo $ifsc_code; ?></div>
        </div>

        <div class="terms">
            <h4>Terms & Conditions:</h4>
            <ol>
                <li>All Subject to Local Jurisdiction.</li>
                <li>This is a computer generated receipt.</li>
                <li>Please keep this receipt for your records.</li>
                <li>E.& O.E.</li>
            </ol>
        </div>

        <div class="footer">
            <div class="seal">
                <?php echo strtoupper($school_name); ?><br>
                FEE RECEIPT
            </div>
            <div class="signature">
                <strong>For - <?php echo $school_name; ?></strong><br><br>
                <div style="border-top: 1px solid #333; width: 200px; margin-left: auto;">
                    Authorized Signature
                </div>
            </div>
        </div>
    </div>

    <script>
        // Auto-print when page loads (optional)
        // window.onload = function() { window.print(); }
    </script>
</body>
</html>
