<?php
require_once 'config/config.php';
require_once 'config/database.php';

requireLogin();

$database = new Database();
$db = $database->getConnection();

$error_message = '';
$success_message = '';

// Handle form submission
if ($_POST && isset($_POST['update_settings'])) {
    $school_name = sanitizeInput($_POST['school_name']);
    $school_address = sanitizeInput($_POST['school_address']);
    $school_contact = sanitizeInput($_POST['school_contact']);
    $gstin = sanitizeInput($_POST['gstin']);
    $bank_name = sanitizeInput($_POST['bank_name']);
    $account_number = sanitizeInput($_POST['account_number']);
    $ifsc_code = sanitizeInput($_POST['ifsc_code']);

    // Create or update settings table
    $create_table = "CREATE TABLE IF NOT EXISTS invoice_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        setting_key VARCHAR(100) UNIQUE NOT NULL,
        setting_value TEXT,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $db->exec($create_table);

    // Update settings
    $settings = [
        'school_name' => $school_name,
        'school_address' => $school_address,
        'school_contact' => $school_contact,
        'gstin' => $gstin,
        'bank_name' => $bank_name,
        'account_number' => $account_number,
        'ifsc_code' => $ifsc_code
    ];

    foreach ($settings as $key => $value) {
        $query = "INSERT INTO invoice_settings (setting_key, setting_value) VALUES (?, ?) 
                  ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)";
        $stmt = $db->prepare($query);
        $stmt->execute([$key, $value]);
    }

    $success_message = 'Invoice settings updated successfully!';
}

// Get current settings
$settings_query = "SELECT setting_key, setting_value FROM invoice_settings";
$settings_stmt = $db->prepare($settings_query);
$settings_stmt->execute();
$settings_data = $settings_stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// Default values
$school_name = $settings_data['school_name'] ?? 'Student Management System';
$school_address = $settings_data['school_address'] ?? 'Your School Address, City, State, PIN';
$school_contact = $settings_data['school_contact'] ?? 'Phone: +91-XXXXXXXXXX | Email: info@yourschool.com';
$gstin = $settings_data['gstin'] ?? '22AAAAA0000A1Z5';
$bank_name = $settings_data['bank_name'] ?? 'Your Bank Name';
$account_number = $settings_data['account_number'] ?? 'XXXXXXXXXXXXXX';
$ifsc_code = $settings_data['ifsc_code'] ?? 'XXXX0000000';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice Settings - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 2px 0;
            transition: all 0.3s ease;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        .main-content {
            background-color: #f8f9fa;
            min-height: 100vh;
        }
        .form-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            overflow: hidden;
        }
        .form-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1.5rem;
        }
        .form-control, .form-select {
            border-radius: 8px;
            border: 2px solid #e9ecef;
            padding: 10px 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .required {
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="p-3">
                        <h4 class="text-center mb-4">
                            <i class="fas fa-graduation-cap me-2"></i>
                            <?php echo APP_NAME; ?>
                        </h4>
                        <nav class="nav flex-column">
                            <a class="nav-link" href="index.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                            <a class="nav-link" href="add_student.php">
                                <i class="fas fa-user-plus me-2"></i>Add Student
                            </a>
                            <a class="nav-link" href="fee_deposit.php">
                                <i class="fas fa-credit-card me-2"></i>Fee Deposit
                            </a>
                            <a class="nav-link" href="fee_history.php">
                                <i class="fas fa-history me-2"></i>Fee History
                            </a>
                            <a class="nav-link" href="student_info.php">
                                <i class="fas fa-info-circle me-2"></i>Student Info
                            </a>
                            <a class="nav-link" href="reports.php">
                                <i class="fas fa-chart-bar me-2"></i>Reports
                            </a>
                            <a class="nav-link" href="settings.php">
                                <i class="fas fa-cog me-2"></i>Settings
                            </a>
                            <a class="nav-link active" href="invoice_settings.php">
                                <i class="fas fa-file-invoice me-2"></i>Invoice Settings
                            </a>
                            <hr class="my-3">
                            <a class="nav-link" href="logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                            </a>
                        </nav>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Top Navigation -->
                    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
                        <div class="container-fluid">
                            <span class="navbar-brand mb-0 h1">Invoice Settings</span>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Welcome, <?php echo $_SESSION['admin_name']; ?></span>
                                <div class="dropdown">
                                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-user-circle"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i>Profile</a></li>
                                        <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog me-2"></i>Settings</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </nav>

                    <div class="p-4">
                        <div class="row justify-content-center">
                            <div class="col-lg-8">
                                <div class="form-container">
                                    <div class="form-header">
                                        <h4 class="mb-0">
                                            <i class="fas fa-file-invoice me-2"></i>Invoice Settings
                                        </h4>
                                        <p class="mb-0">Configure invoice and receipt details</p>
                                    </div>

                                    <div class="p-4">
                                        <?php if ($error_message): ?>
                                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                <?php echo $error_message; ?>
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                            </div>
                                        <?php endif; ?>

                                        <?php if ($success_message): ?>
                                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                                <i class="fas fa-check-circle me-2"></i>
                                                <?php echo $success_message; ?>
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                            </div>
                                        <?php endif; ?>

                                        <form method="POST" action="">
                                            <div class="row">
                                                <!-- School Information -->
                                                <div class="col-12">
                                                    <h6 class="text-primary mb-3">
                                                        <i class="fas fa-school me-2"></i>School/Institution Information
                                                    </h6>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label for="school_name" class="form-label">School/Institution Name <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="school_name" name="school_name" 
                                                           value="<?php echo htmlspecialchars($school_name); ?>" required>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label for="school_address" class="form-label">Address <span class="required">*</span></label>
                                                    <textarea class="form-control" id="school_address" name="school_address" rows="3" required><?php echo htmlspecialchars($school_address); ?></textarea>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label for="school_contact" class="form-label">Contact Information <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="school_contact" name="school_contact" 
                                                           value="<?php echo htmlspecialchars($school_contact); ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="gstin" class="form-label">GSTIN</label>
                                                    <input type="text" class="form-control" id="gstin" name="gstin" 
                                                           value="<?php echo htmlspecialchars($gstin); ?>" placeholder="22AAAAA0000A1Z5">
                                                </div>

                                                <!-- Bank Information -->
                                                <div class="col-12 mt-4">
                                                    <h6 class="text-primary mb-3">
                                                        <i class="fas fa-university me-2"></i>Bank Information
                                                    </h6>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label for="bank_name" class="form-label">Bank Name <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="bank_name" name="bank_name" 
                                                           value="<?php echo htmlspecialchars($bank_name); ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="account_number" class="form-label">Account Number <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="account_number" name="account_number" 
                                                           value="<?php echo htmlspecialchars($account_number); ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="ifsc_code" class="form-label">IFSC Code <span class="required">*</span></label>
                                                    <input type="text" class="form-control" id="ifsc_code" name="ifsc_code" 
                                                           value="<?php echo htmlspecialchars($ifsc_code); ?>" required>
                                                </div>
                                            </div>

                                            <div class="d-flex justify-content-end mt-4">
                                                <a href="fee_history.php" class="btn btn-secondary me-3">
                                                    <i class="fas fa-times me-2"></i>Cancel
                                                </a>
                                                <button type="submit" name="update_settings" class="btn btn-primary btn-submit">
                                                    <i class="fas fa-save me-2"></i>Update Settings
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
