<?php
require_once 'config/database.php';

class Student {
    private $conn;
    private $table_name = "students";

    public $id;
    public $student_name;
    public $fathers_name;
    public $mothers_name;
    public $date_of_birth;
    public $gender;
    public $joining_date;
    public $total_fee;
    public $contact_number;
    public $email;
    public $address;
    public $emergency_contact;
    public $student_id;
    public $status;
    public $reference_name;
    public $exit_date;
    public $document_name;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Create new student
    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  (student_name, fathers_name, mothers_name, date_of_birth, gender, 
                   joining_date, total_fee, contact_number, email, 
                   address, emergency_contact, student_id, status, reference_name, exit_date, document_name) 
                  VALUES 
                  (:student_name, :fathers_name, :mothers_name, :date_of_birth, :gender, 
                   :joining_date, :total_fee, :contact_number, :email, 
                   :address, :emergency_contact, :student_id, :status, :reference_name, :exit_date, :document_name)";

        $stmt = $this->conn->prepare($query);

        // Bind values
        $stmt->bindParam(':student_name', $this->student_name);
        $stmt->bindParam(':fathers_name', $this->fathers_name);
        $stmt->bindParam(':mothers_name', $this->mothers_name);
        $stmt->bindParam(':date_of_birth', $this->date_of_birth);
        $stmt->bindParam(':gender', $this->gender);
        $stmt->bindParam(':joining_date', $this->joining_date);
        $stmt->bindParam(':total_fee', $this->total_fee);
        $stmt->bindParam(':contact_number', $this->contact_number);
        $stmt->bindParam(':email', $this->email);
        $stmt->bindParam(':address', $this->address);
        $stmt->bindParam(':emergency_contact', $this->emergency_contact);
        $stmt->bindParam(':student_id', $this->student_id);
        $stmt->bindParam(':status', $this->status);
        $stmt->bindParam(':reference_name', $this->reference_name);
        $stmt->bindParam(':exit_date', $this->exit_date);
        $stmt->bindParam(':document_name', $this->document_name);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Read all students
    public function readAll() {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY created_at DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Read single student
    public function readOne() {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = :id LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if($row) {
            $this->student_name = $row['student_name'];
            $this->fathers_name = $row['fathers_name'];
            $this->mothers_name = $row['mothers_name'];
            $this->date_of_birth = $row['date_of_birth'];
            $this->gender = $row['gender'];
            $this->joining_date = $row['joining_date'];
            $this->total_fee = $row['total_fee'];
            $this->contact_number = $row['contact_number'];
            $this->email = $row['email'];
            $this->address = $row['address'];
            $this->emergency_contact = $row['emergency_contact'];
            $this->student_id = $row['student_id'];
            $this->status = $row['status'];
            $this->reference_name = $row['reference_name'];
            $this->exit_date = $row['exit_date'];
            $this->document_name = $row['document_name'];
            return true;
        }
        return false;
    }

    // Update student
    public function update() {
        $query = "UPDATE " . $this->table_name . " 
                  SET student_name = :student_name, 
                      fathers_name = :fathers_name, 
                      mothers_name = :mothers_name, 
                      date_of_birth = :date_of_birth, 
                      gender = :gender, 
                      joining_date = :joining_date, 
                      total_fee = :total_fee, 
                      contact_number = :contact_number, 
                      email = :email, 
                      address = :address, 
                      emergency_contact = :emergency_contact, 
                      status = :status,
                      reference_name = :reference_name,
                      exit_date = :exit_date,
                      document_name = :document_name
                  WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        // Bind values
        $stmt->bindParam(':student_name', $this->student_name);
        $stmt->bindParam(':fathers_name', $this->fathers_name);
        $stmt->bindParam(':mothers_name', $this->mothers_name);
        $stmt->bindParam(':date_of_birth', $this->date_of_birth);
        $stmt->bindParam(':gender', $this->gender);
        $stmt->bindParam(':joining_date', $this->joining_date);
        $stmt->bindParam(':total_fee', $this->total_fee);
        $stmt->bindParam(':contact_number', $this->contact_number);
        $stmt->bindParam(':email', $this->email);
        $stmt->bindParam(':address', $this->address);
        $stmt->bindParam(':emergency_contact', $this->emergency_contact);
        $stmt->bindParam(':status', $this->status);
        $stmt->bindParam(':reference_name', $this->reference_name);
        $stmt->bindParam(':exit_date', $this->exit_date);
        $stmt->bindParam(':document_name', $this->document_name);
        $stmt->bindParam(':id', $this->id);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Delete student
    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $this->id);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Search students
    public function search($search_term) {
        $query = "SELECT * FROM " . $this->table_name . " 
                  WHERE student_name LIKE :search_term 
                  OR fathers_name LIKE :search_term 
                  OR mothers_name LIKE :search_term 
                  OR student_id LIKE :search_term 
                  OR contact_number LIKE :search_term 
                  ORDER BY created_at DESC";
        
        $stmt = $this->conn->prepare($query);
        $search_term = "%{$search_term}%";
        $stmt->bindParam(':search_term', $search_term);
        $stmt->execute();
        return $stmt;
    }

    // Get statistics
    public function getStats() {
        $query = "SELECT 
                    COUNT(*) as total_students,
                    SUM(total_fee) as total_fees,
                    COALESCE((SELECT SUM(amount) FROM fee_history), 0) as total_deposits,
                    SUM(total_fee) - COALESCE((SELECT SUM(amount) FROM fee_history), 0) as total_pending,
                    COUNT(CASE WHEN status = 'Active' THEN 1 END) as active_students
                  FROM " . $this->table_name;
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>
