<?php
require_once 'config/config.php';
require_once 'config/database.php';
require_once 'models/Admin.php';

requireLogin();

$database = new Database();
$db = $database->getConnection();
$admin = new Admin($db);

$error_message = '';
$success_message = '';

// Get current admin info
$admin->getById($_SESSION['admin_id']);

if ($_POST) {
    if (isset($_POST['update_profile'])) {
        // Update profile
        $full_name = sanitizeInput($_POST['full_name']);
        $email = sanitizeInput($_POST['email']);
        
        if (empty($full_name) || empty($email)) {
            $error_message = 'Please fill in all required fields!';
        } else {
            $query = "UPDATE admins SET full_name = :full_name, email = :email WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':full_name', $full_name);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':id', $_SESSION['admin_id']);
            
            if ($stmt->execute()) {
                $_SESSION['admin_name'] = $full_name;
                $success_message = 'Profile updated successfully!';
                $admin->full_name = $full_name;
                $admin->email = $email;
            } else {
                $error_message = 'Failed to update profile!';
            }
        }
    } elseif (isset($_POST['change_password'])) {
        // Change password
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];
        
        if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
            $error_message = 'Please fill in all password fields!';
        } elseif ($new_password !== $confirm_password) {
            $error_message = 'New passwords do not match!';
        } elseif (strlen($new_password) < 6) {
            $error_message = 'New password must be at least 6 characters long!';
        } else {
            // Verify current password
            $query = "SELECT password FROM admins WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $_SESSION['admin_id']);
            $stmt->execute();
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (password_verify($current_password, $row['password'])) {
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $query = "UPDATE admins SET password = :password WHERE id = :id";
                $stmt = $db->prepare($query);
                $stmt->bindParam(':password', $hashed_password);
                $stmt->bindParam(':id', $_SESSION['admin_id']);
                
                if ($stmt->execute()) {
                    $success_message = 'Password changed successfully!';
                } else {
                    $error_message = 'Failed to change password!';
                }
            } else {
                $error_message = 'Current password is incorrect!';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 2px 0;
            transition: all 0.3s ease;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        .main-content {
            background-color: #f8f9fa;
            min-height: 100vh;
        }
        .settings-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            overflow: hidden;
        }
        .settings-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1.5rem;
        }
        .form-control, .form-select {
            border-radius: 8px;
            border: 2px solid #e9ecef;
            padding: 10px 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .required {
            color: #dc3545;
        }
        .nav-pills .nav-link {
            border-radius: 8px;
            margin: 2px;
        }
        .nav-pills .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="p-3">
                        <h4 class="text-center mb-4">
                            <i class="fas fa-graduation-cap me-2"></i>
                            <?php echo APP_NAME; ?>
                        </h4>
                        <nav class="nav flex-column">
                            <a class="nav-link" href="index.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                            <a class="nav-link" href="add_student.php">
                                <i class="fas fa-user-plus me-2"></i>Add Student
                            </a>
                            <a class="nav-link" href="reports.php">
                                <i class="fas fa-chart-bar me-2"></i>Reports
                            </a>
                            <a class="nav-link active" href="settings.php">
                                <i class="fas fa-cog me-2"></i>Settings
                            </a>
                            <hr class="my-3">
                            <a class="nav-link" href="logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                            </a>
                        </nav>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Top Navigation -->
                    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
                        <div class="container-fluid">
                            <span class="navbar-brand mb-0 h1">Settings</span>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Welcome, <?php echo $_SESSION['admin_name']; ?></span>
                                <div class="dropdown">
                                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-user-circle"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i>Profile</a></li>
                                        <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog me-2"></i>Settings</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </nav>

                    <div class="p-4">
                        <div class="row justify-content-center">
                            <div class="col-lg-8">
                                <div class="settings-card">
                                    <div class="settings-header">
                                        <h4 class="mb-0">
                                            <i class="fas fa-cog me-2"></i>Settings
                                        </h4>
                                        <p class="mb-0">Manage your account settings</p>
                                    </div>

                                    <div class="p-4">
                                        <?php if ($error_message): ?>
                                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                <?php echo $error_message; ?>
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                            </div>
                                        <?php endif; ?>

                                        <?php if ($success_message): ?>
                                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                                <i class="fas fa-check-circle me-2"></i>
                                                <?php echo $success_message; ?>
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                            </div>
                                        <?php endif; ?>

                                        <!-- Settings Tabs -->
                                        <ul class="nav nav-pills mb-4" id="settingsTabs" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="profile-tab" data-bs-toggle="pill" data-bs-target="#profile" type="button" role="tab">
                                                    <i class="fas fa-user me-2"></i>Profile
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="password-tab" data-bs-toggle="pill" data-bs-target="#password" type="button" role="tab">
                                                    <i class="fas fa-lock me-2"></i>Password
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="system-tab" data-bs-toggle="pill" data-bs-target="#system" type="button" role="tab">
                                                    <i class="fas fa-cogs me-2"></i>System
                                                </button>
                                            </li>
                                        </ul>

                                        <div class="tab-content" id="settingsTabsContent">
                                            <!-- Profile Tab -->
                                            <div class="tab-pane fade show active" id="profile" role="tabpanel">
                                                <h5 class="mb-3">Profile Information</h5>
                                                <form method="POST" action="">
                                                    <input type="hidden" name="update_profile" value="1">
                                                    
                                                    <div class="row">
                                                        <div class="col-md-6 mb-3">
                                                            <label for="username" class="form-label">Username</label>
                                                            <input type="text" class="form-control" id="username" value="<?php echo $admin->username; ?>" readonly>
                                                            <small class="text-muted">Username cannot be changed</small>
                                                        </div>
                                                        <div class="col-md-6 mb-3">
                                                            <label for="full_name" class="form-label">Full Name <span class="required">*</span></label>
                                                            <input type="text" class="form-control" id="full_name" name="full_name" 
                                                                   value="<?php echo $admin->full_name; ?>" required>
                                                        </div>
                                                        <div class="col-md-6 mb-3">
                                                            <label for="email" class="form-label">Email Address <span class="required">*</span></label>
                                                            <input type="email" class="form-control" id="email" name="email" 
                                                                   value="<?php echo $admin->email; ?>" required>
                                                        </div>
                                                    </div>

                                                    <div class="d-flex justify-content-end">
                                                        <button type="submit" class="btn btn-primary btn-submit">
                                                            <i class="fas fa-save me-2"></i>Update Profile
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>

                                            <!-- Password Tab -->
                                            <div class="tab-pane fade" id="password" role="tabpanel">
                                                <h5 class="mb-3">Change Password</h5>
                                                <form method="POST" action="">
                                                    <input type="hidden" name="change_password" value="1">
                                                    
                                                    <div class="row">
                                                        <div class="col-md-6 mb-3">
                                                            <label for="current_password" class="form-label">Current Password <span class="required">*</span></label>
                                                            <input type="password" class="form-control" id="current_password" name="current_password" required>
                                                        </div>
                                                        <div class="col-md-6 mb-3">
                                                            <label for="new_password" class="form-label">New Password <span class="required">*</span></label>
                                                            <input type="password" class="form-control" id="new_password" name="new_password" required>
                                                            <small class="text-muted">Minimum 6 characters</small>
                                                        </div>
                                                        <div class="col-md-6 mb-3">
                                                            <label for="confirm_password" class="form-label">Confirm New Password <span class="required">*</span></label>
                                                            <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                                        </div>
                                                    </div>

                                                    <div class="d-flex justify-content-end">
                                                        <button type="submit" class="btn btn-primary btn-submit">
                                                            <i class="fas fa-key me-2"></i>Change Password
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>

                                            <!-- System Tab -->
                                            <div class="tab-pane fade" id="system" role="tabpanel">
                                                <h5 class="mb-3">System Information</h5>
                                                
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <div class="card bg-light">
                                                            <div class="card-body">
                                                                <h6 class="card-title">
                                                                    <i class="fas fa-info-circle me-2"></i>Application Info
                                                                </h6>
                                                                <p class="mb-1"><strong>Name:</strong> <?php echo APP_NAME; ?></p>
                                                                <p class="mb-1"><strong>Version:</strong> <?php echo APP_VERSION; ?></p>
                                                                <p class="mb-0"><strong>PHP Version:</strong> <?php echo PHP_VERSION; ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="card bg-light">
                                                            <div class="card-body">
                                                                <h6 class="card-title">
                                                                    <i class="fas fa-database me-2"></i>Database Info
                                                                </h6>
                                                                <p class="mb-1"><strong>Host:</strong> localhost</p>
                                                                <p class="mb-1"><strong>Database:</strong> student_management</p>
                                                                <p class="mb-0"><strong>Status:</strong> <span class="text-success">Connected</span></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="alert alert-info">
                                                    <h6><i class="fas fa-lightbulb me-2"></i>System Tips</h6>
                                                    <ul class="mb-0">
                                                        <li>Regularly backup your database</li>
                                                        <li>Keep your password secure and change it periodically</li>
                                                        <li>Monitor system logs for any issues</li>
                                                        <li>Update the system regularly for security patches</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Password confirmation validation
        document.getElementById('confirm_password').addEventListener('input', function() {
            const newPassword = document.getElementById('new_password').value;
            const confirmPassword = this.value;
            
            if (newPassword !== confirmPassword) {
                this.setCustomValidity('Passwords do not match');
            } else {
                this.setCustomValidity('');
            }
        });
    </script>
</body>
</html>
