<?php
require_once 'config/config.php';
require_once 'config/database.php';
require_once 'models/Student.php';

requireLogin();

$database = new Database();
$db = $database->getConnection();
$student = new Student($db);

// Get student ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    redirect('index.php');
}

$student->id = $_GET['id'];

// Read student data
if (!$student->readOne()) {
    $_SESSION['error_message'] = 'Student not found!';
    redirect('index.php');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Student - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 2px 0;
            transition: all 0.3s ease;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        .main-content {
            background-color: #f8f9fa;
            min-height: 100vh;
        }
        .student-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            overflow: hidden;
        }
        .student-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .info-section {
            padding: 1.5rem;
            border-bottom: 1px solid #e9ecef;
        }
        .info-section:last-child {
            border-bottom: none;
        }
        .info-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0;
            border-bottom: 1px solid #f8f9fa;
        }
        .info-item:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: 600;
            color: #495057;
        }
        .info-value {
            color: #6c757d;
        }
        .badge-custom {
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.875rem;
        }
        .age-calculator {
            background: #e3f2fd;
            border-radius: 8px;
            padding: 15px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="p-3">
                        <h4 class="text-center mb-4">
                            <i class="fas fa-graduation-cap me-2"></i>
                            <?php echo APP_NAME; ?>
                        </h4>
                        <nav class="nav flex-column">
                            <a class="nav-link" href="index.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                            <a class="nav-link" href="add_student.php">
                                <i class="fas fa-user-plus me-2"></i>Add Student
                            </a>
                            <a class="nav-link" href="reports.php">
                                <i class="fas fa-chart-bar me-2"></i>Reports
                            </a>
                            <a class="nav-link" href="settings.php">
                                <i class="fas fa-cog me-2"></i>Settings
                            </a>
                            <hr class="my-3">
                            <a class="nav-link" href="logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                            </a>
                        </nav>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Top Navigation -->
                    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
                        <div class="container-fluid">
                            <span class="navbar-brand mb-0 h1">Student Details</span>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Welcome, <?php echo $_SESSION['admin_name']; ?></span>
                                <div class="dropdown">
                                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-user-circle"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i>Profile</a></li>
                                        <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog me-2"></i>Settings</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </nav>

                    <div class="p-4">
                        <div class="row justify-content-center">
                            <div class="col-lg-8">
                                <div class="student-card">
                                    <div class="student-header">
                                        <div class="mb-3">
                                            <i class="fas fa-user-circle fa-4x"></i>
                                        </div>
                                        <h3 class="mb-2"><?php echo $student->student_name; ?></h3>
                                        <p class="mb-0">Student ID: <?php echo $student->student_id; ?></p>
                                        <span class="badge badge-custom bg-<?php echo $student->status == 'Active' ? 'success' : ($student->status == 'Inactive' ? 'danger' : 'info'); ?> mt-2">
                                            <?php echo $student->status; ?>
                                        </span>
                                    </div>

                                    <!-- Personal Information -->
                                    <div class="info-section">
                                        <h5 class="text-primary mb-3">
                                            <i class="fas fa-user me-2"></i>Personal Information
                                        </h5>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Full Name</span>
                                            <span class="info-value"><?php echo $student->student_name; ?></span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Father's Name</span>
                                            <span class="info-value"><?php echo $student->fathers_name; ?></span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Mother's Name</span>
                                            <span class="info-value"><?php echo $student->mothers_name; ?></span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Date of Birth</span>
                                            <span class="info-value"><?php echo formatDate($student->date_of_birth); ?></span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Gender</span>
                                            <span class="info-value">
                                                <span class="badge bg-<?php echo $student->gender == 'Male' ? 'primary' : ($student->gender == 'Female' ? 'danger' : 'secondary'); ?>">
                                                    <?php echo $student->gender; ?>
                                                </span>
                                            </span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Joining Date</span>
                                            <span class="info-value"><?php echo formatDate($student->joining_date); ?></span>
                                        </div>

                                        <!-- Age Calculator -->
                                        <div class="age-calculator">
                                            <div class="row text-center">
                                                <div class="col-4">
                                                    <h6 class="text-primary mb-1">Age</h6>
                                                    <h4 class="mb-0"><?php 
                                                        $dob = new DateTime($student->date_of_birth);
                                                        $today = new DateTime();
                                                        $age = $today->diff($dob);
                                                        echo $age->y . ' years';
                                                    ?></h4>
                                                </div>
                                                <div class="col-4">
                                                    <h6 class="text-primary mb-1">Duration</h6>
                                                    <h4 class="mb-0"><?php 
                                                        $join = new DateTime($student->joining_date);
                                                        $duration = $today->diff($join);
                                                        echo $duration->y . 'y ' . $duration->m . 'm';
                                                    ?></h4>
                                                </div>
                                                <div class="col-4">
                                                    <h6 class="text-primary mb-1">Status</h6>
                                                    <h4 class="mb-0">
                                                        <span class="badge bg-<?php echo $student->status == 'Active' ? 'success' : ($student->status == 'Inactive' ? 'danger' : 'info'); ?>">
                                                            <?php echo $student->status; ?>
                                                        </span>
                                                    </h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Contact Information -->
                                    <div class="info-section">
                                        <h5 class="text-primary mb-3">
                                            <i class="fas fa-phone me-2"></i>Contact Information
                                        </h5>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Contact Number</span>
                                            <span class="info-value">
                                                <?php if ($student->contact_number): ?>
                                                    <a href="tel:<?php echo $student->contact_number; ?>" class="text-decoration-none">
                                                        <i class="fas fa-phone me-1"></i><?php echo $student->contact_number; ?>
                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-muted">Not provided</span>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Email Address</span>
                                            <span class="info-value">
                                                <?php if ($student->email): ?>
                                                    <a href="mailto:<?php echo $student->email; ?>" class="text-decoration-none">
                                                        <i class="fas fa-envelope me-1"></i><?php echo $student->email; ?>
                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-muted">Not provided</span>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Emergency Contact</span>
                                            <span class="info-value">
                                                <?php if ($student->emergency_contact): ?>
                                                    <a href="tel:<?php echo $student->emergency_contact; ?>" class="text-decoration-none">
                                                        <i class="fas fa-phone me-1"></i><?php echo $student->emergency_contact; ?>
                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-muted">Not provided</span>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                        
                                        <div class="info-item">
                                            <span class="info-label">Address</span>
                                            <span class="info-value">
                                                <?php echo $student->address ? $student->address : '<span class="text-muted">Not provided</span>'; ?>
                                            </span>
                                        </div>
                                    </div>

                                    <!-- Fee Information -->
                                    <div class="info-section">
                                        <h5 class="text-primary mb-3">
                                            <i class="fas fa-rupee-sign me-2"></i>Fee Information
                                        </h5>
                                        
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <div class="text-center p-3 bg-light rounded">
                                                    <h6 class="text-muted mb-1">Total Fee</h6>
                                                    <h4 class="text-primary mb-0"><?php echo formatCurrency($student->total_fee); ?></h4>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <div class="text-center p-3 bg-light rounded">
                                                    <h6 class="text-muted mb-1">Deposited</h6>
                                                    <h4 class="text-success mb-0"><?php echo formatCurrency($student->fees_deposit); ?></h4>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <div class="text-center p-3 bg-light rounded">
                                                    <h6 class="text-muted mb-1">Pending</h6>
                                                    <h4 class="text-<?php echo ($student->total_fee - $student->fees_deposit) > 0 ? 'warning' : 'success'; ?> mb-0">
                                                        <?php echo formatCurrency($student->total_fee - $student->fees_deposit); ?>
                                                    </h4>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="progress mb-3" style="height: 20px;">
                                            <?php 
                                            $percentage = $student->total_fee > 0 ? ($student->fees_deposit / $student->total_fee) * 100 : 0;
                                            ?>
                                            <div class="progress-bar bg-<?php echo $percentage == 100 ? 'success' : ($percentage > 50 ? 'info' : 'warning'); ?>" 
                                                 role="progressbar" style="width: <?php echo $percentage; ?>%">
                                                <?php echo number_format($percentage, 1); ?>%
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Action Buttons -->
                                    <div class="info-section text-center">
                                        <a href="edit_student.php?id=<?php echo $student->id; ?>" class="btn btn-primary me-2">
                                            <i class="fas fa-edit me-2"></i>Edit Student
                                        </a>
                                        <a href="index.php" class="btn btn-secondary">
                                            <i class="fas fa-arrow-left me-2"></i>Back to List
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
