<?php
// Admin user checker and creator
echo "<h2>Admin User Check & Creator</h2>";
echo "<style>body{font-family:Arial;margin:20px;} .ok{color:green;} .error{color:red;} .warning{color:orange;} .info{color:blue;}</style>";

try {
    // Connect to database
    $pdo = new PDO("mysql:host=localhost;dbname=student_management", "root", "");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<div class='ok'>✓ Database connection successful</div>";

    // Check if admins table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'admins'");
    if ($stmt->rowCount() > 0) {
        echo "<div class='ok'>✓ Admins table exists</div>";
        
        // Check admin users
        $stmt = $pdo->query("SELECT id, username, email, full_name FROM admins");
        $admins = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if (count($admins) > 0) {
            echo "<div class='ok'>✓ Found " . count($admins) . " admin user(s):</div>";
            echo "<table border='1' style='border-collapse:collapse; margin:10px 0;'>";
            echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Full Name</th></tr>";
            foreach ($admins as $admin) {
                echo "<tr>";
                echo "<td>" . $admin['id'] . "</td>";
                echo "<td>" . $admin['username'] . "</td>";
                echo "<td>" . $admin['email'] . "</td>";
                echo "<td>" . $admin['full_name'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<div class='error'>✗ No admin users found</div>";
        }
        
    } else {
        echo "<div class='error'>✗ Admins table does not exist</div>";
    }

} catch (PDOException $e) {
    echo "<div class='error'>✗ Database error: " . $e->getMessage() . "</div>";
}

echo "<hr>";
echo "<h3>Create/Reset Admin User</h3>";
echo "<form method='POST' action=''>";
echo "<table>";
echo "<tr><td>Username:</td><td><input type='text' name='username' value='admin' required></td></tr>";
echo "<tr><td>Password:</td><td><input type='password' name='password' value='admin123' required></td></tr>";
echo "<tr><td>Email:</td><td><input type='email' name='email' value='admin@school.com' required></td></tr>";
echo "<tr><td>Full Name:</td><td><input type='text' name='full_name' value='System Administrator' required></td></tr>";
echo "<tr><td colspan='2'><input type='submit' name='create_admin' value='Create/Update Admin User'></td></tr>";
echo "</table>";
echo "</form>";

if ($_POST && isset($_POST['create_admin'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $email = $_POST['email'];
    $full_name = $_POST['full_name'];
    
    try {
        // Hash the password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        // Check if admin exists
        $stmt = $pdo->prepare("SELECT id FROM admins WHERE username = ?");
        $stmt->execute([$username]);
        
        if ($stmt->rowCount() > 0) {
            // Update existing admin
            $stmt = $pdo->prepare("UPDATE admins SET password = ?, email = ?, full_name = ? WHERE username = ?");
            $stmt->execute([$hashed_password, $email, $full_name, $username]);
            echo "<div class='ok'>✓ Admin user '$username' updated successfully!</div>";
        } else {
            // Create new admin
            $stmt = $pdo->prepare("INSERT INTO admins (username, password, email, full_name) VALUES (?, ?, ?, ?)");
            $stmt->execute([$username, $hashed_password, $email, $full_name]);
            echo "<div class='ok'>✓ Admin user '$username' created successfully!</div>";
        }
        
        echo "<div class='info'>You can now login with username: <strong>$username</strong> and password: <strong>$password</strong></div>";
        
    } catch (PDOException $e) {
        echo "<div class='error'>✗ Error creating admin: " . $e->getMessage() . "</div>";
    }
}

echo "<hr>";
echo "<h3>Test Login</h3>";
echo "<form method='POST' action=''>";
echo "<table>";
echo "<tr><td>Username:</td><td><input type='text' name='test_username' value='admin' required></td></tr>";
echo "<tr><td>Password:</td><td><input type='password' name='test_password' required></td></tr>";
echo "<tr><td colspan='2'><input type='submit' name='test_login' value='Test Login'></td></tr>";
echo "</table>";
echo "</form>";

if ($_POST && isset($_POST['test_login'])) {
    $test_username = $_POST['test_username'];
    $test_password = $_POST['test_password'];
    
    try {
        $stmt = $pdo->prepare("SELECT id, username, password, email, full_name FROM admins WHERE username = ?");
        $stmt->execute([$test_username]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($admin && password_verify($test_password, $admin['password'])) {
            echo "<div class='ok'>✓ Login test successful! User: " . $admin['full_name'] . "</div>";
        } else {
            echo "<div class='error'>✗ Login test failed! Invalid username or password.</div>";
        }
        
    } catch (PDOException $e) {
        echo "<div class='error'>✗ Login test error: " . $e->getMessage() . "</div>";
    }
}

echo "<hr>";
echo "<p><a href='login.php'>Go to Login Page</a> | <a href='install.php'>Run Installation</a></p>";
?>
