<?php
// Debug version of login
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Login Debug</h2>";
echo "<style>body{font-family:Arial;margin:20px;} .ok{color:green;} .error{color:red;} .info{color:blue;}</style>";

$error_message = '';

if ($_POST) {
    echo "<h3>Login Attempt:</h3>";
    echo "<div class='info'>Username: " . htmlspecialchars($_POST['username']) . "</div>";
    echo "<div class='info'>Password: " . str_repeat('*', strlen($_POST['password'])) . "</div>";
    
    try {
        // Test database connection
        $pdo = new PDO("mysql:host=localhost;dbname=student_management", "root", "");
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        echo "<div class='ok'>✓ Database connection successful</div>";
        
        // Check if user exists
        $username = $_POST['username'];
        $password = $_POST['password'];
        
        $stmt = $pdo->prepare("SELECT id, username, password, email, full_name FROM admins WHERE username = ?");
        $stmt->execute([$username]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($admin) {
            echo "<div class='ok'>✓ User found: " . $admin['username'] . "</div>";
            echo "<div class='info'>Stored password hash: " . substr($admin['password'], 0, 20) . "...</div>";
            
            // Test password verification
            if (password_verify($password, $admin['password'])) {
                echo "<div class='ok'>✓ Password verification successful!</div>";
                
                // Set session variables
                $_SESSION['admin_id'] = $admin['id'];
                $_SESSION['admin_username'] = $admin['username'];
                $_SESSION['admin_name'] = $admin['full_name'];
                
                echo "<div class='ok'>✓ Session variables set</div>";
                echo "<div class='info'>Redirecting to dashboard...</div>";
                echo "<script>setTimeout(function(){ window.location.href='index.php'; }, 2000);</script>";
                
            } else {
                echo "<div class='error'>✗ Password verification failed</div>";
                $error_message = 'Invalid password!';
            }
        } else {
            echo "<div class='error'>✗ User not found</div>";
            $error_message = 'Invalid username!';
        }
        
    } catch (PDOException $e) {
        echo "<div class='error'>✗ Database error: " . $e->getMessage() . "</div>";
        $error_message = 'Database connection error!';
    }
}

// Show current session status
echo "<h3>Current Session Status:</h3>";
if (isset($_SESSION['admin_id'])) {
    echo "<div class='ok'>✓ Logged in as: " . $_SESSION['admin_name'] . " (ID: " . $_SESSION['admin_id'] . ")</div>";
    echo "<p><a href='index.php'>Go to Dashboard</a> | <a href='logout.php'>Logout</a></p>";
} else {
    echo "<div class='info'>Not logged in</div>";
}

// Show admin users in database
echo "<h3>Admin Users in Database:</h3>";
try {
    $pdo = new PDO("mysql:host=localhost;dbname=student_management", "root", "");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $stmt = $pdo->query("SELECT id, username, email, full_name FROM admins");
    $admins = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($admins) > 0) {
        echo "<table border='1' style='border-collapse:collapse;'>";
        echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Full Name</th></tr>";
        foreach ($admins as $admin) {
            echo "<tr>";
            echo "<td>" . $admin['id'] . "</td>";
            echo "<td>" . $admin['username'] . "</td>";
            echo "<td>" . $admin['email'] . "</td>";
            echo "<td>" . $admin['full_name'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<div class='error'>No admin users found in database</div>";
    }
    
} catch (PDOException $e) {
    echo "<div class='error'>Database error: " . $e->getMessage() . "</div>";
}

// Login form
if (!isset($_SESSION['admin_id'])) {
    echo "<hr>";
    echo "<h3>Login Form:</h3>";
    echo "<form method='POST' action=''>";
    echo "<table>";
    echo "<tr><td>Username:</td><td><input type='text' name='username' value='admin' required></td></tr>";
    echo "<tr><td>Password:</td><td><input type='password' name='password' required></td></tr>";
    echo "<tr><td colspan='2'><input type='submit' value='Login'></td></tr>";
    echo "</table>";
    echo "</form>";
    
    if ($error_message) {
        echo "<div class='error'>" . $error_message . "</div>";
    }
}

echo "<hr>";
echo "<p><a href='setup_admin.php'>Setup Admin User</a> | <a href='check_admin.php'>Check Admin Users</a> | <a href='login.php'>Normal Login</a></p>";
?>
